/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.DSSPEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.ECDSAPEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.KeyPairPEMResourceParser;
import org.apache.sshd.common.config.keys.loader.pem.PKCS8PEMResourceKeyPairParser;
import org.apache.sshd.common.config.keys.loader.pem.RSAPEMResourceKeyPairParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class PEMResourceParserUtils {
    public static final KeyPairResourceParser PROXY = new KeyPairResourceParser(){

        @Override
        public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
            KeyPairResourceParser proxy = (KeyPairResourceParser)PROXY_HOLDER.get();
            return proxy == null ? Collections.emptyList() : proxy.loadKeyPairs(resourceKey, passwordProvider, lines);
        }

        @Override
        public boolean canExtractKeyPairs(String resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
            KeyPairResourceParser proxy = (KeyPairResourceParser)PROXY_HOLDER.get();
            return proxy != null && proxy.canExtractKeyPairs(resourceKey, lines);
        }
    };
    private static final Map<String, KeyPairPEMResourceParser> BY_OID_MAP = new TreeMap<String, KeyPairPEMResourceParser>(String.CASE_INSENSITIVE_ORDER);
    private static final Map<String, KeyPairPEMResourceParser> BY_ALGORITHM_MAP = new TreeMap<String, KeyPairPEMResourceParser>(String.CASE_INSENSITIVE_ORDER);
    private static final AtomicReference<KeyPairResourceParser> PROXY_HOLDER = new AtomicReference<KeyPairResourceParser>(KeyPairResourceParser.EMPTY);

    private PEMResourceParserUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPEMResourceParser(KeyPairPEMResourceParser parser) {
        Objects.requireNonNull(parser, "No parser to register");
        Map<String, KeyPairPEMResourceParser> map = BY_OID_MAP;
        synchronized (map) {
            BY_OID_MAP.put(ValidateUtils.checkNotNullAndNotEmpty(parser.getAlgorithmIdentifier(), "No OID value"), parser);
        }
        map = BY_ALGORITHM_MAP;
        synchronized (map) {
            BY_ALGORITHM_MAP.put(ValidateUtils.checkNotNullAndNotEmpty(parser.getAlgorithm(), "No algorithm value"), parser);
            PROXY_HOLDER.set(KeyPairResourceParser.aggregate(new ArrayList<KeyPairPEMResourceParser>(BY_ALGORITHM_MAP.values())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairPEMResourceParser getPEMResourceParserByOid(String oid) {
        if (GenericUtils.isEmpty(oid)) {
            return null;
        }
        Map<String, KeyPairPEMResourceParser> map = BY_OID_MAP;
        synchronized (map) {
            return BY_OID_MAP.get(oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairPEMResourceParser getPEMResourceParserByAlgorithm(String algorithm) {
        if (GenericUtils.isEmpty(algorithm)) {
            return null;
        }
        Map<String, KeyPairPEMResourceParser> map = BY_ALGORITHM_MAP;
        synchronized (map) {
            return BY_ALGORITHM_MAP.get(algorithm);
        }
    }

    static {
        PEMResourceParserUtils.registerPEMResourceParser(RSAPEMResourceKeyPairParser.INSTANCE);
        PEMResourceParserUtils.registerPEMResourceParser(DSSPEMResourceKeyPairParser.INSTANCE);
        PEMResourceParserUtils.registerPEMResourceParser(ECDSAPEMResourceKeyPairParser.INSTANCE);
        PEMResourceParserUtils.registerPEMResourceParser(PKCS8PEMResourceKeyPairParser.INSTANCE);
    }
}

