/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";
    long handle;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(parent, MessageBox.checkStyle(style)));
        this.checkSubclass();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        long pixbufs;
        long parentHandle = this.parent != null ? this.parent.topHandle() : 0L;
        int dialogFlags = 2;
        if ((this.style & 0x38000) != 0) {
            dialogFlags |= 1;
        }
        int messageType = 0;
        if ((this.style & 8) != 0) {
            messageType = 1;
        }
        if ((this.style & 4) != 0) {
            messageType = 2;
        }
        if ((this.style & 1) != 0) {
            messageType = 3;
        }
        byte[] format = Converter.wcsToMbcs("%s", true);
        byte[] buffer = Converter.wcsToMbcs(this.message, true);
        this.handle = GTK.gtk_message_dialog_new(parentHandle, dialogFlags, messageType, 0, format, buffer);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (parentHandle != 0L && (pixbufs = GTK.gtk_window_get_icon_list(parentHandle)) != 0L) {
            GTK.gtk_window_set_icon_list(this.handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.createButtons(display.getDismissalAlignment());
        buffer = Converter.wcsToMbcs(this.title, true);
        GTK.gtk_window_set_title(this.handle, buffer);
        display.addIdleProc();
        Dialog oldModal = null;
        long group = GTK.gtk_window_get_group(0L);
        GTK.gtk_window_group_add_window(group, this.handle);
        if (GTK.gtk_window_get_modal(this.handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, this.handle, 0L);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        int response = GTK.gtk_dialog_run(this.handle);
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (GTK.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(oldModal);
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy(this.handle);
        return response;
    }

    private void createButtons(int alignment) {
        if (alignment == 16384) {
            if ((this.style & 0x20) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-ok", true), 32);
            }
            if ((this.style & 0x200) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(SWT.getMessage("SWT_Abort"), true), 512);
            }
            if ((this.style & 0x400) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(SWT.getMessage("SWT_Retry"), true), 1024);
            }
            if ((this.style & 0x40) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-yes", true), 64);
            }
            if ((this.style & 0x80) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-no", true), 128);
            }
            if ((this.style & 0x800) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(SWT.getMessage("SWT_Ignore"), true), 2048);
            }
            if ((this.style & 0x100) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-cancel", true), 256);
            }
        } else {
            if ((this.style & 0x100) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-cancel", true), 256);
            }
            if ((this.style & 0x20) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-ok", true), 32);
            }
            if ((this.style & 0x80) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-no", true), 128);
            }
            if ((this.style & 0x40) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs("gtk-yes", true), 64);
            }
            if ((this.style & 0x800) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(SWT.getMessage("SWT_Ignore"), true), 2048);
            }
            if ((this.style & 0x400) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(SWT.getMessage("SWT_Retry"), true), 1024);
            }
            if ((this.style & 0x200) != 0) {
                GTK.gtk_dialog_add_button(this.handle, Converter.wcsToMbcs(SWT.getMessage("SWT_Abort"), true), 512);
            }
        }
    }

    private static int checkStyle(int style) {
        int mask = 4064;
        int bits = style & mask;
        if (bits == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }
}

