/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.swt.graphics.Image;

public enum StateImageProvider {
    TEST("icons/launching/test.gif", "icons/launching/testrun.gif", "icons/launching/teststop.gif", "icons/launching/testerr.gif", "icons/launching/testok.gif"),
    CONTEXT("icons/launching/context.gif", "icons/launching/contextrun.gif", "icons/launching/contextstop.gif", "icons/launching/contexterr.gif", "icons/launching/contextok.gif"),
    VERIFICATION("icons/launching/verification.gif", "icons/launching/verification-run.png", "icons/launching/verification-stop.png", "icons/launching/verification-fail.png", "icons/launching/verification-pass.png"),
    SUITE("icons/launching/tsuite.gif", "icons/launching/tsuiterun.gif", "icons/launching/tsuitestop.gif", "icons/launching/tsuiteerror.gif", "icons/launching/tsuiteok.gif");

    private final String wait;
    private final String run;
    private final String cancel;
    private final String error;
    private final String pass;

    public Image getStateImage(IExecutable.State state, IStatus result) throws CoreException {
        Preconditions.checkState((state != IExecutable.State.COMPLETED || result != null ? 1 : 0) != 0);
        switch (state) {
            case WAITING: {
                return Images.getImage(this.wait);
            }
            case RUNNING: {
                return Images.getImage(this.run);
            }
            case COMPLETED: {
                switch (SimpleSeverity.create((IStatus)result)) {
                    case CANCEL: {
                        return Images.getImage(this.cancel);
                    }
                    case ERROR: {
                        return Images.getImage(this.error);
                    }
                    case OK: {
                        return Images.getImage(this.pass);
                    }
                }
            }
        }
        MultiStatus rv = new MultiStatus("org.eclipse.rcptt.core", 0, new IStatus[]{result}, "Failed to create status for state " + state, null){
            {
                this.setSeverity(4);
            }
        };
        throw new CoreException((IStatus)rv);
    }

    private StateImageProvider(String wait, String run, String cancel, String error, String pass) {
        this.wait = wait;
        this.run = run;
        this.cancel = cancel;
        this.error = error;
        this.pass = pass;
    }
}

