/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.hostbased.HostKeyIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    private Iterator<? extends Map.Entry<KeyPair, ? extends Collection<X509Certificate>>> keys;
    private final HostKeyIdentityProvider clientHostKeys;
    private List<NamedFactory<Signature>> factories;
    private String clientUsername;
    private String clientHostname;

    public UserAuthHostBased(HostKeyIdentityProvider clientHostKeys) {
        super(NAME);
        this.clientHostKeys = clientHostKeys;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.keys = HostKeyIdentityProvider.iteratorOf(this.clientHostKeys);
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public void setClientHostname(String clientHostname) {
        this.clientHostname = clientHostname;
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        String name = this.getName();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.keys == null || !this.keys.hasNext()) {
            if (debugEnabled) {
                this.log.debug("sendAuthDataRequest({})[{}][{}] no more keys to send", new Object[]{session, service, name});
            }
            return false;
        }
        Map.Entry<KeyPair, ? extends Collection<X509Certificate>> keyInfo = this.keys.next();
        KeyPair kp = keyInfo.getKey();
        PublicKey pub = kp.getPublic();
        String keyType = KeyUtils.getKeyType(pub);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}][{}] current key details: type={}, fingerprint={}", new Object[]{session, service, name, keyType, KeyUtils.getFingerPrint(pub)});
        }
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, session), "No signature factories for session=%s", session);
        Signature verifier = ValidateUtils.checkNotNull(NamedFactory.create(factories, keyType), "No signer could be located for key type=%s", (Object)keyType);
        byte[] id = session.getSessionId();
        String username = session.getUsername();
        String clientUsername = this.resolveClientUsername();
        String clientHostname = this.resolveClientHostname();
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}][{}] client={}@{}", new Object[]{session, service, name, clientUsername, clientHostname});
        }
        Buffer buffer = session.createBuffer((byte)50, id.length + username.length() + service.length() + clientUsername.length() + clientHostname.length() + keyType.length() + 256 + 64);
        buffer.clear();
        buffer.putRawPublicKey(pub);
        Collection<X509Certificate> certs = keyInfo.getValue();
        if (GenericUtils.size(certs) > 0) {
            for (X509Certificate c : certs) {
                buffer.putRawBytes(c.getEncoded());
            }
        }
        verifier.initSigner(kp.getPrivate());
        byte[] keyBytes = buffer.getCompactData();
        buffer = session.prepareBuffer((byte)50, BufferUtils.clear(buffer));
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putString(keyType);
        buffer.putBytes(keyBytes);
        buffer.putString(clientHostname);
        buffer.putString(clientUsername);
        this.appendSignature(session, service, keyType, pub, keyBytes, clientHostname, clientUsername, verifier, buffer);
        session.writePacket(buffer);
        return true;
    }

    protected void appendSignature(ClientSession session, String service, String keyType, PublicKey key, byte[] keyBytes, String clientHostname, String clientUsername, Signature verifier, Buffer buffer) throws Exception {
        byte[] id = session.getSessionId();
        String username = session.getUsername();
        String name = this.getName();
        ByteArrayBuffer bs = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + keyType.length() + keyBytes.length + clientHostname.length() + clientUsername.length() + 256 + 64, false);
        bs.putBytes(id);
        ((Buffer)bs).putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putString(keyType);
        bs.putBytes(keyBytes);
        bs.putString(clientHostname);
        bs.putString(clientUsername);
        verifier.update(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
        byte[] signature = verifier.sign();
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}][{}] type={}, fingerprint={}, client={}@{}: signature={}", new Object[]{session, service, name, keyType, KeyUtils.getFingerPrint(key), clientUsername, clientHostname, BufferUtils.toHex(signature)});
        }
        bs.clear();
        bs.putString(keyType);
        bs.putBytes(signature);
        buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
    }

    protected String resolveClientUsername() {
        String value = this.getClientUsername();
        return GenericUtils.isEmpty(value) ? OsUtils.getCurrentUser() : value;
    }

    protected String resolveClientHostname() {
        String value = this.getClientHostname();
        if (GenericUtils.isEmpty(value)) {
            value = SshdSocketAddress.toAddressString(SshdSocketAddress.getFirstExternalNetwork4Address());
        }
        return GenericUtils.isEmpty(value) ? "127.0.0.1" : value;
    }
}

