/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.blame.BlameInformationControlCreator;
import org.eclipse.egit.ui.internal.blame.BlameRevision;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class BlameOperation
implements IEGitOperation {
    private Repository repository;
    private CommitFileRevision fileRevision;
    private IStorage storage;
    private String path;
    private RevCommit startCommit;
    private Shell shell;
    private IWorkbenchPage page;
    private int lineNumberToReveal = -1;

    public BlameOperation(Repository repository, IFile storage, String path, RevCommit startCommit, Shell shell, IWorkbenchPage page) {
        this.repository = repository;
        this.storage = storage;
        this.path = path;
        this.startCommit = startCommit;
        this.shell = shell;
        this.page = page;
        this.lineNumberToReveal = -1;
    }

    public BlameOperation(CommitFileRevision revision, Shell shell, IWorkbenchPage page) {
        this(revision, shell, page, -1);
    }

    public BlameOperation(CommitFileRevision revision, Shell shell, IWorkbenchPage page, int lineNumberToReveal) {
        this.fileRevision = revision;
        this.repository = revision.getRepository();
        this.path = revision.getGitPath();
        this.startCommit = revision.getRevCommit();
        this.shell = shell;
        this.page = page;
        this.lineNumberToReveal = lineNumberToReveal;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        BlameResult result;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        final RevisionInformation info = new RevisionInformation();
        BlameCommand command = new BlameCommand(this.repository).setFollowFileRenames(true).setFilePath(this.path);
        if (this.startCommit != null) {
            command.setStartCommit((AnyObjectId)this.startCommit);
        } else {
            try {
                command.setStartCommit((AnyObjectId)this.repository.resolve("HEAD"));
            }
            catch (IOException e) {
                Activator.error("Error resolving HEAD for showing annotations in repository: " + this.repository, e);
                return;
            }
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("Blame_IgnoreWhitespace")) {
            command.setTextComparator(RawTextComparator.WS_IGNORE_ALL);
        }
        try {
            result = command.call();
        }
        catch (Exception e1) {
            Activator.error(e1.getMessage(), e1);
            return;
        }
        progress.worked(1);
        if (result == null) {
            return;
        }
        HashMap<RevCommit, BlameRevision> revisions = new HashMap<RevCommit, BlameRevision>();
        int lineCount = result.getResultContents().size();
        BlameRevision previous = null;
        int i = 0;
        while (i < lineCount) {
            RevCommit commit = result.getSourceCommit(i);
            String sourcePath = result.getSourcePath(i);
            if (commit == null) {
                if (previous != null) {
                    previous.register();
                    previous = null;
                }
            } else {
                BlameRevision revision = (BlameRevision)((Object)revisions.get(commit));
                if (revision == null) {
                    revision = new BlameRevision();
                    revision.setRepository(this.repository);
                    revision.setCommit(commit);
                    revision.setSourcePath(sourcePath);
                    revisions.put(commit, revision);
                    info.addRevision((Revision)revision);
                }
                revision.addSourceLine(i, result.getSourceLine(i));
                if (previous != null) {
                    if (previous == revision) {
                        previous.addLine();
                    } else {
                        previous.register();
                        previous = revision.reset(i);
                    }
                } else {
                    previous = revision.reset(i);
                }
            }
            ++i;
        }
        if (previous != null) {
            previous.register();
        }
        progress.worked(1);
        if (this.shell.isDisposed()) {
            return;
        }
        if (this.fileRevision != null) {
            this.storage = this.fileRevision.getStorage((IProgressMonitor)progress.newChild(1));
        } else {
            progress.worked(1);
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BlameOperation.this.openEditor(info);
            }
        });
    }

    private void openEditor(RevisionInformation info) {
        IRevisionRulerColumn revisionRuler;
        AbstractDecoratedTextEditor editorPart;
        block10: {
            try {
                if (this.storage instanceof IFile) {
                    editorPart = RevisionAnnotationController.openEditor((IWorkbenchPage)this.page, (IFile)((IFile)this.storage));
                    break block10;
                }
                FileRevisionEditorInput editorInput = new FileRevisionEditorInput((IFileRevision)this.fileRevision, this.storage);
                editorPart = EgitUiEditorUtils.openEditor(this.page, editorInput);
                if (!(editorPart instanceof MultiPageEditorPart)) break block10;
                MultiPageEditorPart multiEditor = (MultiPageEditorPart)editorPart;
                IEditorPart[] iEditorPartArray = multiEditor.findEditors((IEditorInput)editorInput);
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart part = iEditorPartArray[n2];
                    if (part instanceof AbstractDecoratedTextEditor) {
                        multiEditor.setActiveEditor(part);
                        editorPart = part;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.handleError("Error displaying blame annotations", e, false);
                return;
            }
        }
        if (!(editorPart instanceof AbstractDecoratedTextEditor)) {
            return;
        }
        AbstractDecoratedTextEditor editor = editorPart;
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)Adapters.adapt((Object)editor, IVerticalRulerInfo.class);
        BlameInformationControlCreator creator = new BlameInformationControlCreator(rulerInfo);
        info.setHoverControlCreator((IInformationControlCreator)creator);
        info.setInformationPresenterControlCreator((IInformationControlCreator)creator);
        editor.showRevisionInformation(info, "org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider");
        if (this.lineNumberToReveal >= 0) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int offset = document.getLineOffset(this.lineNumberToReveal);
                editor.selectAndReveal(offset, 0);
            }
            catch (BadLocationException e) {
                Activator.logError("Error revealing line " + this.lineNumberToReveal, e);
            }
        }
        if ((revisionRuler = (IRevisionRulerColumn)Adapters.adapt((Object)editor, IRevisionRulerColumn.class)) instanceof IRevisionRulerColumnExtension) {
            ((IRevisionRulerColumnExtension)revisionRuler).getRevisionSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)new RevisionSelectionHandler(this.repository, this.path, this.storage));
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    static class BlameHistoryPageInput
    extends HistoryPageInput
    implements IAdaptable {
        private final RevCommit commit;

        BlameHistoryPageInput(Repository repository, RevCommit commit, File file) {
            super(repository, new File[]{file});
            this.commit = commit;
        }

        BlameHistoryPageInput(Repository repository, RevCommit commit, IResource file) {
            super(repository, new IResource[]{file});
            this.commit = commit;
        }

        BlameHistoryPageInput(Repository repository, RevCommit commit) {
            super(repository);
            this.commit = commit;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (RevCommit.class == adapter) {
                return adapter.cast(this.commit);
            }
            return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BlameHistoryPageInput)) {
                return false;
            }
            BlameHistoryPageInput other = (BlameHistoryPageInput)obj;
            return super.equals(obj) && (this.commit == other.commit || this.commit != null && this.commit.equals((AnyObjectId)other.commit));
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.commit == null ? 0 : this.commit.hashCode());
        }
    }

    private static class RevisionSelectionHandler
    implements ISelectionChangedListener {
        private IFile resourceFile;
        private File nonResourceFile;
        private boolean firstSelectionChange = true;

        private RevisionSelectionHandler(Repository repository, String path, IStorage storage) {
            if (storage instanceof IFile) {
                this.resourceFile = (IFile)storage;
            } else if (!repository.isBare()) {
                this.nonResourceFile = new File(repository.getWorkTree(), path);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.firstSelectionChange) {
                this.firstSelectionChange = false;
                return;
            }
            ISelection selection = event.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (!(first instanceof BlameRevision)) {
                return;
            }
            IHistoryView part = (IHistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.team.ui.GenericHistoryView");
            if (part == null) {
                return;
            }
            BlameRevision revision = (BlameRevision)((Object)first);
            BlameHistoryPageInput input = this.resourceFile != null ? new BlameHistoryPageInput(revision.getRepository(), revision.getCommit(), (IResource)this.resourceFile) : (this.nonResourceFile != null ? new BlameHistoryPageInput(revision.getRepository(), revision.getCommit(), this.nonResourceFile) : new BlameHistoryPageInput(revision.getRepository(), revision.getCommit()));
            part.showHistoryFor((Object)input);
        }
    }
}

