/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Optional;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledIfSystemPropertyCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledIfSystemProperty is not present");

    EnabledIfSystemPropertyCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional optional = AnnotationUtils.findAnnotation(context.getElement(), EnabledIfSystemProperty.class);
        if (!optional.isPresent()) {
            return ENABLED_BY_DEFAULT;
        }
        EnabledIfSystemProperty annotation = (EnabledIfSystemProperty)optional.get();
        String name = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank((String)name, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank((String)regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        String actual = System.getProperty(name);
        if (actual == null) {
            return ConditionEvaluationResult.disabled(String.format("System property [%s] does not exist", name));
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.enabled(String.format("System property [%s] with value [%s] matches regular expression [%s]", name, actual, regex));
        }
        return ConditionEvaluationResult.disabled(String.format("System property [%s] with value [%s] does not match regular expression [%s]", name, actual, regex));
    }
}

