/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RetargetAddMemoryBlockAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class AddMemoryRenderingDialog
extends SelectionDialog {
    private IMemoryBlock[] fMemoryBlocks;
    private Combo memoryBlock;
    private ListViewer fViewer;
    private IMemoryBlock fSelectedMemoryBlock;
    private Button addNew;
    private ISelectionChangedListener fSelectionChangedListener;
    private SelectionListener fSelectionListener;
    private SelectionAdapter fAddNewSelectionAdapter;
    private IMemoryRenderingSite fSite;
    private IMemoryBlockListener fMemoryBlockListener = new IMemoryBlockListener(){

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            if (memory.length > 0) {
                IMemoryBlock currentBlock = AddMemoryRenderingDialog.this.getMemoryBlockToSelect(memory[0]);
                if (currentBlock == null) {
                    AddMemoryRenderingDialog.this.addNew();
                } else {
                    AddMemoryRenderingDialog.this.populateDialog(currentBlock);
                }
            }
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
        }
    };
    private IMemoryRenderingBindingsListener fBindingListener = new IMemoryRenderingBindingsListener(){

        @Override
        public void memoryRenderingBindingsChanged() {
            UIJob job = new UIJob("refresh"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AddMemoryRenderingDialog.this.fViewer.refresh();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    };

    public boolean close() {
        this.fViewer.removeSelectionChangedListener(this.fSelectionChangedListener);
        this.memoryBlock.removeSelectionListener(this.fSelectionListener);
        this.addNew.removeSelectionListener((SelectionListener)this.fAddNewSelectionAdapter);
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener(this.fMemoryBlockListener);
        DebugUITools.getMemoryRenderingManager().removeListener(this.fBindingListener);
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            Object[] renderings = ((IStructuredSelection)results[0]).toArray();
            return renderings;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection select = this.fViewer.getSelection();
        this.setSelectionResult(new Object[]{select});
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".AddMemoryRenderingDialog_context");
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 3;
        compositeLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)compositeLayout);
        GridData comositeSpec = new GridData();
        comositeSpec.grabExcessVerticalSpace = true;
        comositeSpec.grabExcessHorizontalSpace = true;
        comositeSpec.horizontalAlignment = 4;
        comositeSpec.verticalAlignment = 2;
        composite.setLayoutData((Object)comositeSpec);
        Label textLabel = new Label(composite, 0);
        textLabel.setText(DebugUIMessages.AddMemoryRenderingDialog_Memory_Monitor);
        GridData textLayout = new GridData();
        textLayout.verticalAlignment = 2;
        textLayout.horizontalAlignment = 1;
        textLabel.setLayoutData((Object)textLayout);
        this.memoryBlock = new Combo(composite, 2056);
        GridData spec = new GridData(768);
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = false;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        spec.horizontalSpan = 4;
        this.memoryBlock.setLayoutData((Object)spec);
        Label filler = new Label(composite, 0);
        filler.setText(" ");
        GridData fillerData = new GridData(768);
        fillerData.horizontalSpan = 2;
        filler.setLayoutData((Object)fillerData);
        this.addNew = new Button(composite, 0);
        this.addNew.setText(DebugUIMessages.AddMemoryRenderingDialog_Add_New);
        GridData specButton = new GridData();
        specButton.horizontalAlignment = 3;
        specButton.verticalAlignment = 2;
        this.addNew.setLayoutData((Object)specButton);
        this.fAddNewSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetargetAddMemoryBlockAction action = new RetargetAddMemoryBlockAction(AddMemoryRenderingDialog.this.fSite, false);
                action.run();
                action.dispose();
            }
        };
        this.addNew.addSelectionListener((SelectionListener)this.fAddNewSelectionAdapter);
        this.fSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = AddMemoryRenderingDialog.this.memoryBlock.getSelectionIndex();
                if (AddMemoryRenderingDialog.this.fMemoryBlocks == null) {
                    return;
                }
                AddMemoryRenderingDialog.this.fSelectedMemoryBlock = AddMemoryRenderingDialog.this.fMemoryBlocks[idx];
                AddMemoryRenderingDialog.this.fViewer.setInput((Object)AddMemoryRenderingDialog.this.fSelectedMemoryBlock);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.memoryBlock.addSelectionListener(this.fSelectionListener);
        Label renderingLabel = new Label(composite, 0);
        renderingLabel.setText(DebugUIMessages.AddMemoryRenderingDialog_Memory_renderings);
        GridData renderingLayout = new GridData();
        renderingLayout.horizontalAlignment = 1;
        renderingLayout.verticalAlignment = 2;
        renderingLayout.horizontalSpan = 3;
        renderingLabel.setLayoutData((Object)renderingLayout);
        this.fViewer = new ListViewer(composite);
        this.fViewer.setContentProvider((IContentProvider)new MemoryRenderingContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MemoryRenderingLabelProvider());
        GridData listLayout = new GridData(1808);
        listLayout.horizontalSpan = 3;
        listLayout.heightHint = 140;
        this.fViewer.getControl().setLayoutData((Object)listLayout);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddMemoryRenderingDialog.this.okPressed();
            }
        });
        IMemoryBlock currentBlock = this.getMemoryBlockToSelect(null);
        if (currentBlock == null) {
            this.addNew();
        } else {
            this.populateDialog(currentBlock);
        }
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = AddMemoryRenderingDialog.this.fViewer.getSelection();
                if (selection.isEmpty()) {
                    AddMemoryRenderingDialog.this.getButton(0).setEnabled(false);
                } else {
                    AddMemoryRenderingDialog.this.getButton(0).setEnabled(true);
                }
            }
        };
        this.fViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener(this.fMemoryBlockListener);
        DebugUITools.getMemoryRenderingManager().addListener(this.fBindingListener);
        return composite;
    }

    public AddMemoryRenderingDialog(Shell parent, IMemoryRenderingSite site) {
        super(parent);
        super.setTitle(DebugUIMessages.AddMemoryRenderingDialog_Add_memory_rendering);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSite = site;
    }

    private void doPopulateDialog(Combo combo, ListViewer viewer, String[] labels, int selectionIdx, IMemoryBlock currentBlock) {
        combo.removeAll();
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            combo.add(label);
            ++n2;
        }
        combo.select(selectionIdx);
        this.fSelectedMemoryBlock = currentBlock;
        viewer.setInput((Object)currentBlock);
    }

    private IMemoryBlock getMemoryBlockToSelect(IMemoryBlock lastAdded) {
        IMemoryBlock currentBlock = null;
        if (lastAdded != null) {
            currentBlock = lastAdded;
        } else {
            ISelectionProvider selectionProvider = this.fSite.getSite().getSelectionProvider();
            ISelection selection = null;
            selection = selectionProvider != null ? selectionProvider.getSelection() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
            IMemoryBlock element = this.getMemoryBlock(selection);
            if (element == null) {
                IAdaptable context = DebugUITools.getPartDebugContext(this.fSite.getSite());
                if (context != null) {
                    IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
                    if (retrieval == null) {
                        return currentBlock;
                    }
                    IMemoryBlock[] blocks = new IMemoryBlock[]{};
                    if (retrieval != null) {
                        blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieval);
                    }
                    if (blocks.length > 0) {
                        currentBlock = blocks[0];
                    }
                }
            } else {
                currentBlock = element;
            }
        }
        return currentBlock;
    }

    private String[] getLabels(IMemoryBlock[] memoryBlocks) {
        String[] labels = new String[memoryBlocks.length];
        int i = 0;
        while (i < memoryBlocks.length) {
            ILabelDecorator decorator;
            String text = "";
            if (memoryBlocks[i] instanceof IMemoryBlockExtension) {
                try {
                    text = ((IMemoryBlockExtension)memoryBlocks[i]).getExpression();
                    if (text == null) {
                        text = DebugUIMessages.AddMemoryRenderingDialog_Unknown;
                    }
                    if (((IMemoryBlockExtension)memoryBlocks[i]).getBigBaseAddress() != null) {
                        text = String.valueOf(text) + " : 0x";
                        text = String.valueOf(text) + ((IMemoryBlockExtension)memoryBlocks[i]).getBigBaseAddress().toString(16);
                    }
                }
                catch (DebugException debugException) {
                    long address = memoryBlocks[i].getStartAddress();
                    text = Long.toHexString(address);
                }
            } else {
                long address = memoryBlocks[i].getStartAddress();
                text = Long.toHexString(address);
            }
            if ((decorator = (ILabelDecorator)this.fMemoryBlocks[i].getAdapter(ILabelDecorator.class)) != null) {
                text = decorator.decorateText(text, (Object)this.fMemoryBlocks[i]);
            }
            labels[i] = text;
            ++i;
        }
        return labels;
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fSelectedMemoryBlock;
    }

    private void populateDialog(IMemoryBlock currentBlock) {
        final IMemoryBlock selectMB = currentBlock;
        Job job = new Job("Populate dialog"){

            protected IStatus run(IProgressMonitor monitor) {
                IMemoryBlockRetrieval mbRetrieval = MemoryViewUtil.getMemoryBlockRetrieval(selectMB);
                if (mbRetrieval != null) {
                    AddMemoryRenderingDialog.this.fMemoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(mbRetrieval);
                    int selectionIdx = 0;
                    int i = 0;
                    while (i < AddMemoryRenderingDialog.this.fMemoryBlocks.length) {
                        if (AddMemoryRenderingDialog.this.fMemoryBlocks[i] == selectMB) {
                            selectionIdx = i;
                            break;
                        }
                        ++i;
                    }
                    final String[] labels = AddMemoryRenderingDialog.this.getLabels(AddMemoryRenderingDialog.this.fMemoryBlocks);
                    final int idx = selectionIdx;
                    final IMemoryBlock selectedBlk = selectMB;
                    WorkbenchJob wbJob = new WorkbenchJob("populate dialog"){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            AddMemoryRenderingDialog.this.doPopulateDialog(AddMemoryRenderingDialog.this.memoryBlock, AddMemoryRenderingDialog.this.fViewer, labels, idx, selectedBlk);
                            return Status.OK_STATUS;
                        }
                    };
                    wbJob.setSystem(true);
                    wbJob.schedule();
                } else {
                    DebugUIPlugin.logErrorMessage("Unable to obtain memory block retrieval.");
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void addNew() {
        WorkbenchJob job = new WorkbenchJob("populate dialog"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AddMemoryRenderingDialog.this.memoryBlock.add(DebugUIMessages.AddMemoryRenderingDialog_Add_New);
                AddMemoryRenderingDialog.this.memoryBlock.select(0);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    class MemoryRenderingContentProvider
    implements IStructuredContentProvider {
        MemoryRenderingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] renderings = DebugUITools.getMemoryRenderingManager().getRenderingTypes((IMemoryBlock)inputElement);
            return renderings;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MemoryRenderingLabelProvider
    implements ILabelProvider {
        MemoryRenderingLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IMemoryRenderingType) {
                String label = ((IMemoryRenderingType)element).getLabel();
                return label;
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

