/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.rcptt.tesla.core.ui.DiagramItem;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.swt.properties.PropertySourceSupport;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySourceBasedModelMapper {
    public static boolean map(IWorkbenchPart part, Object selection, DiagramItem diagramItem) {
        IPropertySource source;
        block4: {
            source = PropertySourceBasedModelMapper.getSource(selection);
            if (source != null) break block4;
            return false;
        }
        try {
            if (PropertySourceSupport.map((IWorkbenchPart)part, (IPropertySource)source, (DiagramItem)diagramItem)) {
                return true;
            }
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
        }
        return false;
    }

    public static boolean isPropertyBasedMapped(IWorkbenchPart part, Object selection) {
        IPropertySource source = PropertySourceBasedModelMapper.getSource(selection);
        if (source == null) {
            return false;
        }
        return PropertySourceSupport.isSourcePropertiesMapped((IWorkbenchPart)part, (IPropertySource)source);
    }

    public static PropertyNodeList getPropertyNodes(IWorkbenchPart part, Object selection, String nodePath) {
        IPropertySource source = PropertySourceBasedModelMapper.getSource(selection);
        if (source == null) {
            return null;
        }
        if (PropertySourceSupport.isSourcePropertiesMapped((IWorkbenchPart)part, (IPropertySource)source)) {
            return PropertySourceSupport.getPropertyNodes((IWorkbenchPart)part, (IPropertySource)source, (String)nodePath);
        }
        return null;
    }

    public static String getPropertyValue(IWorkbenchPart part, Object selection, String nodePath) {
        IPropertySource source = PropertySourceBasedModelMapper.getSource(selection);
        if (source == null) {
            return null;
        }
        if (PropertySourceSupport.isSourcePropertiesMapped((IWorkbenchPart)part, (IPropertySource)source)) {
            return PropertySourceSupport.getPropertyValue((IWorkbenchPart)part, (IPropertySource)source, (String)nodePath);
        }
        return null;
    }

    private static IPropertySource getSource(Object selection) {
        if (selection instanceof IPropertySource) {
            return (IPropertySource)selection;
        }
        if (selection instanceof IPropertySourceProvider) {
            return ((IPropertySourceProvider)selection).getPropertySource(selection);
        }
        return (IPropertySource)PropertySourceBasedModelMapper.getAdapter(selection, IPropertySource.class, false);
    }

    public static Object getAdapter(Object sourceObject, Class<?> adapter, boolean activatePlugins) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull(adapter);
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return adapter.cast(sourceObject);
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            Assert.isTrue((boolean)adapter.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = activatePlugins ? adapter.cast(Platform.getAdapterManager().loadAdapter(sourceObject, adapter.getName())) : Platform.getAdapterManager().getAdapter(sourceObject, adapter)) != null) {
            return result;
        }
        return null;
    }
}

