/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.SingleZipCallModelProvider;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.recommenders.utils.names.VmPackageName;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AdaptiveTemplatesProvider
extends ApidocProvider {
    @Inject
    IProjectCoordinateProvider pcProvider;
    @Inject
    IModelRepository modelRepo;
    @Inject
    IModelIndex modelIndex;

    @JavaSelectionSubscriber
    public void onPackageSelection(IPackageFragment selected, JavaElementSelectionEvent event, Composite parent) {
        IPackageFragmentRoot pfr = (IPackageFragmentRoot)Checks.cast((Object)selected.getAncestor(3));
        Optional<Set<ITypeName>> data = this.fetchData(pfr);
        if (data.isPresent()) {
            Collection typesInPackage = Collections2.filter((Collection)((Collection)data.get()), (Predicate)new Predicate<ITypeName>(selected){
                IPackageName pkg;
                {
                    this.pkg = VmPackageName.get((String)iPackageFragment.getElementName().replace(".", "/"));
                }

                public boolean apply(ITypeName t) {
                    return this.pkg.equals(t.getPackage());
                }
            });
            this.runSyncInUiThread(new AcquireableTypesRenderer(parent, typesInPackage, false));
        }
    }

    @JavaSelectionSubscriber
    public void onPackageRootSelection(IPackageFragmentRoot selected, JavaElementSelectionEvent event, Composite parent) {
        Optional<Set<ITypeName>> data = this.fetchData(selected);
        if (data.isPresent()) {
            this.runSyncInUiThread(new AcquireableTypesRenderer(parent, (Collection)data.get(), true));
        }
    }

    @JavaSelectionSubscriber
    public void onProjectSelection(IJavaProject selected, JavaElementSelectionEvent event, Composite parent) {
        Optional<Set<ITypeName>> data = this.fetchData(selected);
        if (data.isPresent()) {
            this.runSyncInUiThread(new AcquireableTypesRenderer(parent, (Collection)data.get(), true));
        }
    }

    @JavaSelectionSubscriber
    public void onTypeSelection(IType selected, JavaElementSelectionEvent event, Composite parent) throws IOException {
        UniqueTypeName name = (UniqueTypeName)this.pcProvider.toUniqueName(selected).orNull();
        if (name == null) {
            return;
        }
        ModelCoordinate mc = (ModelCoordinate)this.modelIndex.suggest(name.getProjectCoordinate(), "call").orNull();
        if (mc == null) {
            return;
        }
        File zip = (File)this.modelRepo.getLocation(mc, true).orNull();
        if (zip == null) {
            return;
        }
        SingleZipCallModelProvider p = new SingleZipCallModelProvider(zip);
        p.open();
        ICallModel model = (ICallModel)p.acquireModel(name).orNull();
        p.close();
        if (model == null) {
            return;
        }
        ArrayList patterns = Lists.newArrayList();
        model.setObservedCalls(Collections.emptySet());
        for (Recommendation def : Recommendations.top((Iterable)model.recommendDefinitions(), (int)5, (double)0.01)) {
            model.reset();
            model.setObservedCalls(Collections.emptySet());
            model.setObservedDefiningMethod((IMethodName)def.getProposal());
            for (Recommendation pattern : Recommendations.top((Iterable)model.recommendPatterns(), (int)3, (double)0.01)) {
                model.setObservedPattern((String)pattern.getProposal());
                List calls = Recommendations.top((Iterable)model.recommendCalls(), (int)8, (double)0.1);
                if (calls.size() < 2) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(model.getReceiverType().getClassName()).append(" var = ").append(Names.vm2srcQualifiedMethod((IMethodName)((IMethodName)def.getProposal()))).append(IOUtils.LINE_SEPARATOR);
                for (Recommendation call : calls) {
                    sb.append("var.").append(Names.vm2srcSimpleMethod((IMethodName)((IMethodName)call.getProposal()))).append(IOUtils.LINE_SEPARATOR);
                }
                patterns.add(sb.toString());
            }
        }
        this.runSyncInUiThread(new CodeRenderer(parent, patterns));
    }

    private Optional<Set<ITypeName>> fetchData(IPackageFragmentRoot selectedPackageFragmentRoot) {
        Optional opc = this.pcProvider.resolve(selectedPackageFragmentRoot);
        if (opc.isPresent()) {
            return this.fetchData((ProjectCoordinate)opc.get());
        }
        return Optional.absent();
    }

    private Optional<Set<ITypeName>> fetchData(IJavaProject javaProject) {
        Optional opc = this.pcProvider.resolve(javaProject);
        if (opc.isPresent()) {
            return this.fetchData((ProjectCoordinate)opc.get());
        }
        return Optional.absent();
    }

    private Optional<Set<ITypeName>> fetchData(ProjectCoordinate pc) {
        Optional omc = this.modelIndex.suggest(pc, "call");
        if (omc.isPresent()) {
            return this.fetchData((ModelCoordinate)omc.get());
        }
        return Optional.absent();
    }

    private Optional<Set<ITypeName>> fetchData(ModelCoordinate mc) {
        Optional file = this.modelRepo.getLocation(mc, true);
        if (!file.isPresent()) {
            return Optional.absent();
        }
        SingleZipCallModelProvider modelProvider = new SingleZipCallModelProvider((File)file.get());
        try {
            modelProvider.open();
            Set acquireableTypes = modelProvider.acquireableTypes();
            modelProvider.close();
            return Optional.of((Object)acquireableTypes);
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
    }

    class AcquireableTypesRenderer
    implements Runnable {
        private Composite parent;
        private List<ITypeName> types;
        private boolean showPackages;

        public AcquireableTypesRenderer(Composite parent, Collection<ITypeName> acquireableTypes, boolean showPackages) {
            this.parent = parent;
            this.types = this.sort(acquireableTypes);
            this.showPackages = showPackages;
        }

        private List<ITypeName> sort(Collection<ITypeName> acquireableTypes) {
            ArrayList types = Lists.newArrayList(acquireableTypes);
            Collections.sort(types, new Comparator<ITypeName>(){

                @Override
                public int compare(ITypeName o1, ITypeName o2) {
                    return ComparisonChain.start().compare((Comparable)o1.getPackage(), (Comparable)o2.getPackage()).compare((Comparable)((Object)o1.getClassName()), (Comparable)((Object)o2.getClassName())).result();
                }
            });
            return types;
        }

        @Override
        public void run() {
            ApidocsViewUtils.createLabel(this.parent, "Recommendations are available for the following Types: (" + this.types.size() + ")", true);
            org.eclipse.swt.widgets.List typeList = new org.eclipse.swt.widgets.List(this.parent, 0);
            typeList.setBackground(this.parent.getBackground());
            GridData data = new GridData(16384, 1, false, true);
            data.horizontalIndent = 10;
            typeList.setLayoutData((Object)data);
            for (ITypeName typeName : this.types) {
                if (this.showPackages) {
                    typeList.add(Names.vm2srcQualifiedType((ITypeName)typeName));
                    continue;
                }
                typeList.add(typeName.getClassName());
            }
        }
    }

    class CodeRenderer
    implements Runnable {
        private Composite parent;
        private Collection<String> snippets;

        public CodeRenderer(Composite parent, Collection<String> snippets) {
            this.parent = parent;
            this.snippets = snippets;
        }

        @Override
        public void run() {
            ApidocsViewUtils.createLabel(this.parent, "This provider is highly experimental. Select a type name (like \"String\") in your editor \nand it will show a few likely *example* code snippets (" + this.snippets.size() + ") it has found but not all it \nknowns. This provider is for demo purpose only.", true);
            StyledText text = ApidocsViewUtils.createStyledText(this.parent, Joiner.on((String)"\n").join(this.snippets), 2, false);
            GridData data = (GridData)text.getLayoutData();
            data.horizontalIndent = 20;
            ApidocsViewUtils.setInfoBackgroundColor((Control)text);
        }
    }
}

