/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMessageSend;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.calls.NullCallModel;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableCompletionProposalComputer;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.Proposals;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.calls.rcp.CallCompletionContextFunctions;
import org.eclipse.recommenders.internal.calls.rcp.CallsRcpPreferences;
import org.eclipse.recommenders.internal.calls.rcp.Messages;
import org.eclipse.recommenders.internal.calls.rcp.ProposalMatcher;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Constants;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;

public class CallCompletionSessionProcessor
extends SessionProcessor {
    private final Set<Class<? extends ASTNode>> supportedCompletionRequests = new HashSet<Class<? extends ASTNode>>(){
        {
            this.add(CompletionOnMemberAccess.class);
            this.add(CompletionOnMessageSend.class);
            this.add(CompletionOnQualifiedNameReference.class);
            this.add(CompletionOnSingleNameReference.class);
        }
    };
    private final ICallModelProvider modelProvider;
    private final IProjectCoordinateProvider pcProvider;
    private IRecommendersCompletionContext ctx;
    private UniqueTypeName name;
    private ICallModel model;
    private Iterable<Recommendation<IMethodName>> recommendations;
    private CallsRcpPreferences prefs;
    private ImageDescriptor overlay;
    private HashSet<IMethodName> observedCalls;

    @Inject
    public CallCompletionSessionProcessor(IProjectCoordinateProvider pcProvider, ICallModelProvider modelProvider, CallsRcpPreferences prefs, SharedImages images) {
        this.pcProvider = pcProvider;
        this.modelProvider = modelProvider;
        this.prefs = prefs;
        this.overlay = images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        this.ctx = context;
        this.recommendations = Lists.newLinkedList();
        try {
            boolean bl = this.isCompletionRequestSupported() && this.findReceiverTypeAndModel() && this.findRecommendations();
            return bl;
        }
        finally {
            this.releaseModel();
        }
    }

    private boolean findReceiverTypeAndModel() {
        IType receiverType = (IType)this.ctx.get(CallCompletionContextFunctions.RECEIVER_TYPE2, null);
        if (receiverType == null) {
            return false;
        }
        this.name = (UniqueTypeName)this.pcProvider.toUniqueName(receiverType).orNull();
        if (this.name == null) {
            return false;
        }
        this.model = (ICallModel)this.modelProvider.acquireModel((IUniqueName)this.name).or((Object)NullCallModel.INSTANCE);
        return this.model != null;
    }

    private boolean isCompletionRequestSupported() {
        ASTNode node = (ASTNode)this.ctx.getCompletionNode().orNull();
        if (node == null) {
            return false;
        }
        for (Class<? extends ASTNode> supportedCompletionRequest : this.supportedCompletionRequests) {
            if (!supportedCompletionRequest.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    private boolean findRecommendations() {
        IMethod overrides = (IMethod)this.ctx.get(CompletionContextKey.ENCLOSING_METHOD_FIRST_DECLARATION, null);
        if (overrides != null) {
            IMethodName crOverrides = (IMethodName)this.pcProvider.toName(overrides).or((Object)Constants.UNKNOWN_METHOD);
            this.model.setObservedOverrideContext(crOverrides);
        }
        this.model.setObservedDefinitionKind((ICallModel.DefinitionKind)this.ctx.get(CallCompletionContextFunctions.RECEIVER_DEF_TYPE, null));
        this.model.setObservedDefiningMethod((IMethodName)this.ctx.get(CallCompletionContextFunctions.RECEIVER_DEF_BY, null));
        this.observedCalls = Sets.newHashSet((Iterable)((Iterable)this.ctx.get(CallCompletionContextFunctions.RECEIVER_CALLS, Collections.emptyList())));
        this.model.setObservedCalls(this.observedCalls);
        this.recommendations = this.model.recommendCalls();
        if (this.ctx.getExpectedTypeSignature().isPresent()) {
            this.recommendations = Recommendations.filterVoid(this.recommendations);
        }
        this.recommendations = Recommendations.top(this.recommendations, (int)this.prefs.maxNumberOfProposals, (double)((double)this.prefs.minProposalProbability / 100.0));
        return !Iterables.isEmpty(this.recommendations);
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelProvider.releaseModel((Object)this.model);
        }
    }

    public void process(IProcessableProposal proposal) {
        if (Iterables.isEmpty(this.recommendations)) {
            return;
        }
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().or((Object)ProcessableCompletionProposalComputer.NULL_PROPOSAL);
        switch (coreProposal.getKind()) {
            case 6: 
            case 12: 
            case 24: {
                ProposalMatcher matcher = new ProposalMatcher(coreProposal);
                if (this.prefs.highlightUsedProposals && this.handleAlreadyUsedProposal(proposal, matcher)) {
                    return;
                }
                this.handleRecommendation(proposal, matcher);
            }
        }
    }

    private boolean handleAlreadyUsedProposal(IProcessableProposal proposal, ProposalMatcher matcher) {
        for (IMethodName observed : this.observedCalls) {
            String label;
            if (!matcher.match(observed)) continue;
            int boost = this.prefs.changeProposalRelevance ? 1 : 0;
            String string = label = this.prefs.decorateProposalText ? Messages.PROPOSAL_LABEL_USED : "";
            if (this.prefs.decorateProposalIcon) {
                Proposals.overlay((IProcessableProposal)proposal, (ImageDescriptor)this.overlay);
            }
            ProposalProcessorManager manager = proposal.getProposalProcessorManager();
            manager.addProcessor((ProposalProcessor)new SimpleProposalProcessor(boost, label));
            return true;
        }
        return false;
    }

    private void handleRecommendation(IProcessableProposal proposal, ProposalMatcher matcher) {
        for (Recommendation<IMethodName> call : this.recommendations) {
            String label;
            IMethodName crMethod = (IMethodName)call.getProposal();
            if (!matcher.match(crMethod)) continue;
            int boost = this.prefs.changeProposalRelevance ? 200 + Recommendations.asPercentage(call) : 0;
            String string = label = this.prefs.decorateProposalText ? MessageFormat.format(Messages.PROPOSAL_LABEL_PERCENTAGE, call.getRelevance()) : "";
            if (this.prefs.decorateProposalIcon) {
                Proposals.overlay((IProcessableProposal)proposal, (ImageDescriptor)this.overlay);
            }
            if (boost > 0) {
                proposal.setTag((IProposalTag)ProposalTag.RECOMMENDERS_SCORE, (Object)Recommendations.asPercentage(call));
            }
            ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
            mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(boost, label));
            return;
        }
    }

    @VisibleForTesting
    public ICallModel getModel() {
        return this.model;
    }
}

