/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.apidoc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.Selection;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.SearchResult;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.utils.ASTNodeUtils;
import org.eclipse.recommenders.rcp.utils.Logs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

final class ContentProvider
implements ILazyContentProvider {
    private final ExecutorService s = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(20), new ThreadFactoryBuilder().setPriority(1).build());
    public static MethodDeclaration EMPTY;
    private TableViewer viewer;
    private final SearchResult searchResults;

    static {
        AST ast = AST.newAST((int)4);
        EMPTY = ast.newMethodDeclaration();
        EMPTY.setName(ast.newSimpleName("not_found"));
        EMPTY.setBody(ast.newBlock());
    }

    ContentProvider(SearchResult searchResults, JavaElementResolver jdtResolver) {
        this.searchResults = searchResults;
    }

    public void dispose() {
        this.s.shutdown();
    }

    public void updateElement(final int index) {
        try {
            this.s.submit(new Runnable(){
                private IMethod jdtMethod;
                private MethodDeclaration astMethod;
                private IJavaElement element;

                @Override
                public void run() {
                    try {
                        Document doc = ContentProvider.this.searchResults.scoreDoc(index);
                        if (!this.findHandle(doc)) {
                            IllegalStateException e = new IllegalStateException("Could not find handle " + doc.get("Handle"));
                            ContentProvider.this.updateIndex(new Selection(e), index);
                            return;
                        }
                        if (!this.findJdtMethod()) {
                            ContentProvider.this.updateIndex(new Selection(EMPTY, "", doc), index);
                            return;
                        }
                        if (!this.findAstMethod()) {
                            ContentProvider.this.updateIndex(new Selection(EMPTY, "", doc), index);
                            return;
                        }
                        ContentProvider.this.updateIndex(new Selection(this.astMethod, doc.get("VariableName"), doc), index);
                    }
                    catch (Exception e) {
                        ContentProvider.this.updateIndex(new Selection(e), index);
                    }
                }

                private boolean findHandle(Document doc) {
                    String handle = doc.get("Handle");
                    this.element = JavaCore.create((String)handle);
                    return this.element != null;
                }

                private boolean findJdtMethod() {
                    this.jdtMethod = (IMethod)this.element.getAncestor(9);
                    return this.jdtMethod != null;
                }

                private boolean findAstMethod() {
                    CompilationUnit ast;
                    block5: {
                        ITypeRoot cu;
                        block4: {
                            cu = this.jdtMethod.getTypeRoot();
                            if (cu != null) break block4;
                            return false;
                        }
                        ast = SharedASTProvider.getAST((ITypeRoot)cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
                        if (ast != null) break block5;
                        return false;
                    }
                    try {
                        this.astMethod = (MethodDeclaration)ASTNodeUtils.find((CompilationUnit)ast, (IMethod)this.jdtMethod).orNull();
                    }
                    catch (Exception e) {
                        Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"failed to find declaring method %s", (Object[])new Object[]{this.jdtMethod});
                    }
                    return this.astMethod != null;
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.updateIndex(new Selection(new RuntimeException("Too many rendering requests at once. Select this item again to refresh.")), index);
        }
    }

    private void updateIndex(final Selection s, final int index) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Table table = ContentProvider.this.viewer.getTable();
                if (table.isDisposed()) {
                    return;
                }
                ContentProvider.this.viewer.replace((Object)s, index);
            }
        });
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
    }
}

