/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.apidoc;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.ContentProvider;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.Selection;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.SearchResult;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.utils.ASTNodeUtils;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LabelProvider
extends StyledCellLabelProvider {
    private final JavaElementLabelProvider jdtLabelProvider = new JavaElementLabelProvider();
    private MethodDeclaration astMethod;
    private List<ASTNode> statements;
    private final List<String> searchterms;

    public LabelProvider(JavaElementResolver jdtCache, List<String> searchterms, SearchResult searchResults) {
        this.searchterms = searchterms;
    }

    public void update(ViewerCell cell) {
        cell.setFont(JFaceResources.getTextFont());
        Selection s = (Selection)cell.getElement();
        this.astMethod = s.method;
        String varname = s.varname;
        if (s.isError()) {
            cell.setText(s.exception.getMessage());
            return;
        }
        if (this.astMethod == ContentProvider.EMPTY) {
            cell.setText("// failed to resolve method.");
            this.setCellToCommentStyle(cell);
            return;
        }
        if (!this.findStatements(varname)) {
            cell.setText("// No interesting statements found.\n// Either index is outdated or method is not actually using this variable?");
            this.setCellToCommentStyle(cell);
            super.update(cell);
            return;
        }
        this.setCellText(cell);
    }

    private void setCellToCommentStyle(ViewerCell cell) {
        IColorManager colorManager = JavaUI.getColorManager();
        Color color = colorManager.getColor("java_multi_line_comment");
        StyleRange[] ranges = new StyleRange[]{new StyleRange(0, cell.getText().length(), color, null)};
        cell.setStyleRanges(ranges);
    }

    private boolean findStatements(final String varname) {
        this.statements = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)varname)) {
            return false;
        }
        this.astMethod.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (node.getIdentifier().equals(varname)) {
                    this.collectStatement(node);
                }
                return false;
            }

            private void collectStatement(SimpleName node) {
                ASTNode curr = node.getParent();
                while (curr != null) {
                    if (curr instanceof ExpressionStatement) {
                        LabelProvider.this.statements.add(curr);
                        return;
                    }
                    if (curr instanceof ReturnStatement) {
                        LabelProvider.this.statements.add(curr);
                        return;
                    }
                    curr = curr.getParent();
                }
                ASTNode sup = node.getParent();
                switch (sup.getNodeType()) {
                    case 14: {
                        ASTNode supSup = sup.getParent();
                        switch (supSup.getNodeType()) {
                            case 7: 
                            case 14: {
                                LabelProvider.this.statements.add(supSup);
                                break;
                            }
                            case 59: {
                                ASTNode supSupSup = supSup.getParent();
                                if (supSupSup instanceof VariableDeclarationStatement) {
                                    LabelProvider.this.statements.add(supSupSup);
                                    break;
                                }
                                LabelProvider.this.statements.add(supSup);
                            }
                        }
                        break;
                    }
                    case 41: {
                        if (((ReturnStatement)sup).getExpression() instanceof SimpleName) break;
                    }
                    case 11: 
                    case 17: 
                    case 22: 
                    case 32: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 59: {
                        LabelProvider.this.statements.add(sup);
                        break;
                    }
                }
            }
        });
        return !this.statements.isEmpty();
    }

    private void setCellText(ViewerCell cell) {
        StringBuilder sb = new StringBuilder();
        for (ASTNode n : this.statements) {
            sb.append(n.toString()).append(IOUtils.LINE_SEPARATOR);
        }
        Object[] split = StringUtils.split((String)sb.toString(), (String)IOUtils.LINE_SEPARATOR);
        String summary = StringUtils.join((Object[])ArrayUtils.subarray((Object[])split, (int)0, (int)3), (String)IOUtils.LINE_SEPARATOR);
        cell.setText(summary);
        ArrayList ranges = Lists.newArrayList();
        Color color = JavaUI.getColorManager().getColor("java_keyword");
        for (String term : this.searchterms) {
            int index = 0;
            while ((index = StringUtils.indexOfIgnoreCase((CharSequence)summary, (CharSequence)term, (int)index)) != -1) {
                ranges.add(new StyleRange(index, term.length(), color, null));
                index += term.length();
            }
        }
        cell.setFont(JFaceResources.getTextFont());
        cell.setStyleRanges(ranges.toArray(new StyleRange[0]));
    }

    protected void measure(Event event, Object element) {
        TableItem item = (TableItem)event.item;
        GC gc = event.gc;
        gc.setFont(item.getFont());
        Point size = gc.textExtent("\n\n\n");
        Table parent = item.getParent();
        Rectangle clientArea = parent.getClientArea();
        int clientWidth = clientArea.width;
        event.width = clientWidth - 20;
        event.height = size.y;
        Rectangle bounds = item.getBounds();
        gc.setForeground(Display.getDefault().getSystemColor(15));
        gc.drawLine(bounds.x, bounds.y, bounds.x + clientWidth, bounds.y);
        super.measure(event, element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof Selection) {
            Selection s = (Selection)element;
            if (s.method != null) {
                Optional enclosingType = ASTNodeUtils.getClosestParent((ASTNode)s.method, TypeDeclaration.class);
                return String.valueOf(enclosingType.isPresent() ? "class " + ((TypeDeclaration)enclosingType.get()).resolveBinding().getQualifiedName() : "") + "\n" + s.method.toString();
            }
            if (s.isError()) {
                return Throwables.getStackTraceAsString((Throwable)s.exception);
            }
            if (s.doc != null) {
                return s.doc.toString();
            }
        }
        return null;
    }

    public Image getToolTipImage(Object object) {
        if (object instanceof Selection) {
            Selection s = (Selection)object;
            return this.jdtLabelProvider.getImage((Object)s.element());
        }
        return null;
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 100;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public void dispose() {
        super.dispose();
    }
}

