/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.apidoc;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.Renderer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.CodeSearcher;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.SearchResult;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.swt.widgets.Composite;

public class LocalExamplesProvider
extends ApidocProvider {
    private final JavaElementResolver jdtResolver;
    private final CodeSearcher searcher;
    private Stopwatch watch;
    private JavaElementSelectionEvent event;
    private MethodDeclaration enclosingMethod;
    private TypeDeclaration enclosingType;
    private SimpleName varNode;
    private String varType;
    List<String> searchterms;
    private IType jdtVarType;

    @Inject
    public LocalExamplesProvider(CodeSearcher searcher, JavaElementResolver jdtResolver) throws IOException {
        this.searcher = searcher;
        this.jdtResolver = jdtResolver;
    }

    @JavaSelectionSubscriber(value={JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_BODY})
    public void onFieldSelection(IField var, JavaElementSelectionEvent event, Composite parent) throws IOException, JavaModelException {
        this.event = event;
        this.startMeasurement();
        if (!this.findAstNodes()) {
            return;
        }
        if (!this.findVariableType(var.getTypeSignature())) {
            return;
        }
        BooleanQuery query = this.createQuery();
        SearchResult searchResult = this.searcher.lenientSearch((Query)query, 5000);
        this.stopMeasurement();
        this.runSyncInUiThread(new Renderer(searchResult, parent, this.varType, this.watch.toString(), this.jdtResolver, this.searchterms));
    }

    @JavaSelectionSubscriber
    public void onVariableSelection(ILocalVariable var, JavaElementSelectionEvent event, Composite parent) throws IOException, JavaModelException {
        this.event = event;
        this.startMeasurement();
        if (!this.findAstNodes()) {
            return;
        }
        if (!this.findVariableType(var.getTypeSignature())) {
            return;
        }
        BooleanQuery query = this.createQuery();
        SearchResult searchResults = this.searcher.lenientSearch((Query)query, 5000);
        this.stopMeasurement();
        this.runSyncInUiThread(new Renderer(searchResults, parent, this.varType, this.watch.toString(), this.jdtResolver, this.searchterms));
    }

    private boolean findAstNodes() {
        Optional astNode = this.event.getSelectedNode();
        if (!astNode.isPresent()) {
            return false;
        }
        ASTNode node = (ASTNode)astNode.get();
        if (node.getNodeType() == 42) {
            this.varNode = (SimpleName)node;
        }
        SimpleName parent = this.varNode;
        while (parent != null) {
            if (parent instanceof MethodDeclaration) {
                this.enclosingMethod = (MethodDeclaration)parent;
            } else if (parent instanceof TypeDeclaration) {
                this.enclosingType = (TypeDeclaration)parent;
                break;
            }
            parent = parent.getParent();
        }
        return this.varNode != null && this.enclosingMethod != null && this.enclosingType != null;
    }

    private boolean findVariableType(String typeSignature) {
        Optional method = JdtUtils.resolveMethod((MethodDeclaration)this.enclosingMethod);
        if (!method.isPresent()) {
            return false;
        }
        Optional opt = JdtUtils.findTypeFromSignature((String)typeSignature, (IJavaElement)((IJavaElement)method.get()));
        if (!opt.isPresent()) {
            return false;
        }
        this.jdtVarType = (IType)opt.get();
        this.varType = this.jdtResolver.toRecType((IType)opt.get()).getIdentifier();
        return this.varType != null;
    }

    private BooleanQuery createQuery() {
        BooleanQuery query = new BooleanQuery();
        Term typeTerm = CodeSearcher.prepareSearchTerm("VariableType", this.varType);
        TermQuery typeQuery = new TermQuery(typeTerm);
        query.add((Query)typeQuery, BooleanClause.Occur.MUST);
        this.searchterms = Lists.newArrayList();
        this.searchterms.add(this.varNode.getIdentifier());
        this.searchterms.add(this.jdtVarType.getElementName());
        SimpleName[] simpleNameArray = LinkedNodeFinder.findByNode((ASTNode)this.enclosingMethod, (SimpleName)this.varNode);
        int n = simpleNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName use = simpleNameArray[n2];
            ASTNode astParent = use.getParent();
            Term term = null;
            switch (astParent.getNodeType()) {
                case 14: {
                    ClassInstanceCreation targetMethod = (ClassInstanceCreation)astParent;
                    IMethodBinding methodBinding = targetMethod.resolveConstructorBinding();
                    Optional<String> optMethod = BindingHelper.getIdentifier(methodBinding);
                    if (!optMethod.isPresent()) break;
                    this.searchterms.add(targetMethod.getType().toString());
                    if (this.isUsedInArguments(use, targetMethod.arguments())) {
                        term = CodeSearcher.prepareSearchTerm("UsedAsTargetForMethods", (String)optMethod.get());
                        break;
                    }
                    term = CodeSearcher.prepareSearchTerm("UsedAsTargetForMethods", (String)optMethod.get());
                    break;
                }
                case 32: {
                    ClassInstanceCreation targetMethod = (MethodInvocation)astParent;
                    IMethodBinding methodBinding = targetMethod.resolveMethodBinding();
                    Optional<String> optMethod = BindingHelper.getIdentifier(methodBinding);
                    if (!optMethod.isPresent()) break;
                    this.searchterms.add(targetMethod.getName().toString());
                    if (this.isUsedInArguments(use, targetMethod.arguments())) {
                        term = CodeSearcher.prepareSearchTerm("UsedAsTargetForMethods", (String)optMethod.get());
                        break;
                    }
                    term = CodeSearcher.prepareSearchTerm("UsedAsTargetForMethods", (String)optMethod.get());
                    break;
                }
                case 44: {
                    term = CodeSearcher.prepareSearchTerm("VariableDefinition", "parameter");
                    break;
                }
                case 59: {
                    VariableDeclarationFragment declParent = (VariableDeclarationFragment)use.getParent();
                    Expression initializer = declParent.getInitializer();
                    Optional<Pair<IMethod, String>> def = Optional.absent();
                    if (initializer == null) {
                        term = CodeSearcher.prepareSearchTerm("VariableDefinition", "uninitialized");
                        break;
                    }
                    block6 : switch (initializer.getNodeType()) {
                        case 33: {
                            term = CodeSearcher.prepareSearchTerm("VariableDefinition", "nullLiteral");
                            break;
                        }
                        case 48: {
                            term = CodeSearcher.prepareSearchTerm("VariableDefinition", "assignment");
                            def = LocalExamplesProvider.findMethod((SuperMethodInvocation)initializer);
                            break;
                        }
                        case 32: {
                            term = CodeSearcher.prepareSearchTerm("VariableDefinition", "assignment");
                            def = LocalExamplesProvider.findMethod((MethodInvocation)initializer);
                            break;
                        }
                        case 14: {
                            term = CodeSearcher.prepareSearchTerm("VariableDefinition", "instanceCreation");
                            def = LocalExamplesProvider.findMethod((ClassInstanceCreation)initializer);
                            break;
                        }
                        case 11: {
                            Expression expression = ((CastExpression)initializer).getExpression();
                            switch (expression.getNodeType()) {
                                case 32: {
                                    def = LocalExamplesProvider.findMethod((MethodInvocation)expression);
                                    break block6;
                                }
                                case 48: {
                                    def = LocalExamplesProvider.findMethod((SuperMethodInvocation)expression);
                                }
                            }
                        }
                    }
                    if (!def.isPresent()) break;
                    this.searchterms.add(((IMethod)((Pair)def.get()).getFirst()).getElementName());
                    TermQuery subquery = new TermQuery(CodeSearcher.prepareSearchTerm("VariableDefinition", (String)((Pair)def.get()).getSecond()));
                    subquery.setBoost(2.0f);
                    query.add((Query)subquery, BooleanClause.Occur.SHOULD);
                    break;
                }
            }
            if (term != null) {
                query.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            ++n2;
        }
        return query;
    }

    private static Optional<Pair<IMethod, String>> findMethod(MethodInvocation s) {
        return LocalExamplesProvider.findMethod(s.resolveMethodBinding());
    }

    private static Optional<Pair<IMethod, String>> findMethod(SuperMethodInvocation s) {
        return LocalExamplesProvider.findMethod(s.resolveMethodBinding());
    }

    private static Optional<Pair<IMethod, String>> findMethod(ClassInstanceCreation s) {
        return LocalExamplesProvider.findMethod(s.resolveConstructorBinding());
    }

    private static Optional<Pair<IMethod, String>> findMethod(IMethodBinding b) {
        if (b == null) {
            return Optional.absent();
        }
        IMethod method = (IMethod)b.getJavaElement();
        Optional<String> opt = BindingHelper.getIdentifier(b);
        if (method == null || !opt.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)Pair.newPair((Object)method, (Object)((String)opt.get())));
    }

    private boolean isUsedInArguments(SimpleName uses, List arguments) {
        return arguments.size() == 0 || arguments.indexOf(uses) == -1;
    }

    private void startMeasurement() {
        this.watch = new Stopwatch();
        this.watch.start();
    }

    private void stopMeasurement() {
        this.watch.stop();
    }
}

