/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.apidoc;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.ContentProvider;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.LabelProvider;
import org.eclipse.recommenders.codesearch.rcp.index.apidoc.Selection;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.SearchResult;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.utils.Logs;
import org.eclipse.recommenders.rcp.utils.Selections;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.misc.StatusUtil;

public final class Renderer
implements Runnable {
    private final JavaElementResolver jdtResolver;
    private final SearchResult searchResults;
    private final Composite parent;
    private final String typeName;
    private final String searchDuration;
    private final List<String> searchterms;

    public Renderer(SearchResult searchResult, Composite parent, String typeName, String searchDuration, JavaElementResolver jdtResolver, List<String> searchterms) {
        this.searchResults = searchResult;
        this.parent = parent;
        this.typeName = typeName;
        this.searchDuration = searchDuration;
        this.jdtResolver = jdtResolver;
        this.searchterms = searchterms;
    }

    @Override
    public void run() {
        Composite container = new Composite(this.parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ApidocsViewUtils.setInfoBackgroundColor((Control)container);
        Label l = new Label(container, 0);
        String msg = String.format("Found %s examples for type '%s'. Search took %s.", this.searchResults.docs.totalHits, Names.vm2srcSimpleTypeName((String)this.typeName), this.searchDuration);
        l.setText(msg);
        TableViewer v = new TableViewer(container, 0x10000000);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)v, (int)2);
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider(this.jdtResolver, this.searchterms, this.searchResults));
        v.setContentProvider((IContentProvider)new ContentProvider(this.searchResults, this.jdtResolver));
        v.setInput((Object)this.searchResults);
        v.setItemCount(this.searchResults.scoreDocs().length);
        v.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(300, 200).grab(true, false).create());
        v.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Optional opt = Selections.getFirstSelected((ISelection)event.getSelection());
                if (opt.isPresent()) {
                    Selection s = (Selection)opt.get();
                    if (s.isError()) {
                        ErrorDialog.openError((Shell)event.getViewer().getControl().getShell(), (String)"Index issue", (String)"could not open indexed file.", (IStatus)StatusUtil.newStatus((String)"org.eclipse.recommenders", (Throwable)s.exception));
                        return;
                    }
                    String handle = s.doc.get("Handle");
                    IJavaElement create = JavaCore.create((String)handle);
                    try {
                        JavaUI.openInEditor((IJavaElement)create);
                    }
                    catch (Exception e) {
                        Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Failed to open method declaration in editor", (Object[])new Object[0]);
                    }
                }
            }
        });
    }
}

