/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AstHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;

public abstract class AbstractFieldsAccessIndexer {
    protected void addFields(Document document, ASTNode node, String fieldName) {
        this.addFields(document, node, fieldName, null);
    }

    protected void addFields(final Document document, ASTNode node, final String fieldName, final AssignmentSide side) {
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName node) {
                if (side == null || AbstractFieldsAccessIndexer.this.parentIsAssignment((ASTNode)node) && AbstractFieldsAccessIndexer.this.currentNodeCorrectSideOfAssignment((ASTNode)node, side) || side.equals((Object)AssignmentSide.RIGHT)) {
                    SimpleName simpleName = node.getName();
                    Optional<TypeDeclaration> opt = AstHelper.getDeclaringType((ASTNode)node);
                    if (!opt.isPresent()) {
                        return false;
                    }
                    Optional<String> optId = BindingHelper.getIdentifier((TypeDeclaration)opt.get());
                    if (!optId.isPresent()) {
                        return false;
                    }
                    String result = String.format("%1$s.%2$s", optId.get(), simpleName);
                    CodeIndexer.addFieldToDocument(document, fieldName, result);
                }
                return false;
            }
        };
        node.accept(visitor);
    }

    private boolean parentIsAssignment(ASTNode node) {
        return node.getParent() != null && node.getParent() instanceof Assignment;
    }

    private boolean currentNodeCorrectSideOfAssignment(ASTNode node, AssignmentSide side) {
        if (side.equals((Object)AssignmentSide.LEFT)) {
            return ((Assignment)node.getParent()).getLeftHandSide() == node;
        }
        if (side.equals((Object)AssignmentSide.RIGHT)) {
            return ((Assignment)node.getParent()).getRightHandSide() == node;
        }
        return false;
    }

    public static enum AssignmentSide {
        RIGHT,
        LEFT;

    }
}

