/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ImplementedInterfacesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.rcp.utils.AstBindings;
import org.eclipse.recommenders.utils.names.ITypeName;

public class AllImplementedInterfacesIndexer
extends ImplementedInterfacesIndexer
implements IClassIndexer {
    @Override
    public void indexType(Document document, TypeDeclaration type) {
        ITypeBinding b = type.resolveBinding();
        if (b == null) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = b.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding iface;
            ITypeBinding superclass = iface = iTypeBindingArray[n2];
            while (superclass != null) {
                Optional opt = AstBindings.toTypeName((ITypeBinding)superclass);
                if (opt.isPresent()) {
                    CodeIndexer.addFieldToDocument(document, "AllImplementedTypes", ((ITypeName)opt.get()).getIdentifier());
                }
                ITypeBinding iTypeBinding = superclass = superclass.getInterfaces().length > 0 ? superclass.getInterfaces()[0] : null;
            }
            ++n2;
        }
    }
}

