/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;

public class AnnotationsIndexer
implements IClassIndexer,
IMethodIndexer {
    @Override
    public void indexType(Document document, TypeDeclaration type) {
        ITypeBinding clazz = type.resolveBinding();
        if (clazz == null) {
            return;
        }
        this.addAnnotations(document, clazz.getAnnotations());
    }

    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        IMethodBinding methodBinding = method.resolveBinding();
        if (methodBinding == null) {
            return;
        }
        this.addAnnotations(document, methodBinding.getAnnotations());
    }

    private void addAnnotations(Document document, IAnnotationBinding[] annotations) {
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            Optional<String> opt = BindingHelper.getIdentifier(annotation.getAnnotationType());
            if (opt.isPresent()) {
                CodeIndexer.addFieldToDocument(document, "Annotations", (String)opt.get());
                IMemberValuePairBinding[] iMemberValuePairBindingArray = annotation.getAllMemberValuePairs();
                int n3 = iMemberValuePairBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePairBinding valuePairBinding = iMemberValuePairBindingArray[n4];
                    if (valuePairBinding.getValue() instanceof Object[]) {
                        Object[] objectArray = (Object[])valuePairBinding.getValue();
                        int n5 = objectArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object valuePairValue = objectArray[n6];
                            String value = String.valueOf((String)opt.get()) + ":" + valuePairValue;
                            CodeIndexer.addFieldToDocument(document, "Annotations", value);
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

