/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class AstHelper {
    public static boolean isPrimitiveOrArrayOrNullOrObjectOrString(ITypeName type) {
        return AstHelper.isNullOrArrayType(type) || type.isPrimitiveType() || type == VmTypeName.OBJECT || type == VmTypeName.STRING;
    }

    public static boolean isNullOrArrayType(ITypeName type) {
        return type == null || type.isArrayType();
    }

    public static IProject getProject(ASTNode node) {
        while (node != null && !(node instanceof CompilationUnit)) {
            node = node.getParent();
        }
        ITypeRoot root = ((CompilationUnit)node).getTypeRoot();
        if (root == null) {
            IJavaProject property = (IJavaProject)node.getProperty("project");
            return property.getProject();
        }
        return root.getJavaProject().getProject();
    }

    public static Optional<TypeDeclaration> getDeclaringType(ASTNode node) {
        while (node != null) {
            if (node instanceof TypeDeclaration) {
                return Optional.of((Object)((TypeDeclaration)node));
            }
            node = node.getParent();
        }
        return Optional.absent();
    }

    public static Optional<MethodDeclaration> getDeclaringMethod(ASTNode node) {
        while (node != null) {
            if (node instanceof MethodDeclaration) {
                return Optional.of((Object)((MethodDeclaration)node));
            }
            node = node.getParent();
        }
        return Optional.absent();
    }

    public static boolean returnsVoid(MethodDeclaration method) {
        return method != null && AstHelper.isVoid(method.getReturnType2());
    }

    public static boolean isVoid(Type type) {
        return type != null && type.toString().equals("void");
    }
}

