/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.recommenders.rcp.utils.AstBindings;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class BindingHelper {
    public static Optional<String> getIdentifier(MethodDeclaration node) {
        IMethodBinding b = node.resolveBinding();
        return BindingHelper.getIdentifier(b);
    }

    public static Optional<String> getIdentifier(FieldDeclaration node) {
        ITypeBinding b = node.getType().resolveBinding();
        return BindingHelper.getIdentifier(b);
    }

    public static Optional<String> getIdentifier(Optional<TypeDeclaration> node) {
        return BindingHelper.getIdentifier((TypeDeclaration)node.orNull());
    }

    public static Optional<String> getIdentifier(Type node) {
        if (node == null) {
            return Optional.absent();
        }
        ITypeBinding b = node.resolveBinding();
        return BindingHelper.getIdentifier(b);
    }

    public static Optional<String> getIdentifier(TypeDeclaration node) {
        if (node == null) {
            return Optional.absent();
        }
        ITypeBinding b = node.resolveBinding();
        return BindingHelper.getIdentifier(b);
    }

    public static Optional<String> getIdentifier(VariableDeclarationStatement node) {
        try {
            ITypeBinding b = node.getType().resolveBinding();
            return BindingHelper.getIdentifier(b);
        }
        catch (NullPointerException nullPointerException) {
            return Optional.absent();
        }
    }

    public static Optional<String> getIdentifier(ITypeBinding b) {
        if (b == null) {
            return Optional.absent();
        }
        Optional opt = AstBindings.toTypeName((ITypeBinding)b);
        if (!opt.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((ITypeName)opt.get()).getIdentifier());
    }

    public static Optional<String> getTypeIdentifier(SimpleName n) {
        return BindingHelper.getIdentifier(n.resolveTypeBinding());
    }

    public static Optional<String> getIdentifier(MethodInvocation m) {
        return BindingHelper.getIdentifier(m.resolveMethodBinding());
    }

    public static Optional<String> getIdentifier(IMethodBinding b) {
        if (b == null) {
            return Optional.absent();
        }
        Optional opt = AstBindings.toMethodName((IMethodBinding)b);
        if (!opt.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((IMethodName)opt.get()).getIdentifier());
    }
}

