/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AllDeclaredFieldNamesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AllDeclaredMethodNamesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AllExtendedTypesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AllImplementedInterfacesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AnnotationsIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CaughtTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CheckedExceptionsIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexerConfigBean;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexerDefaultConfigBean;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DeclaredFieldNamesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DeclaredFieldTypesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DeclaredMethodNamesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DeclaredMethodsIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DeclaringMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DeclaringTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.DocumentTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ExtendedTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.FieldTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.FieldsReadIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.FieldsWrittenIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.FullTextIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.FullTextIndexer2;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ICompilationUnitIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ImplementedInterfacesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.InstanceOfIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.JavaElementHandleIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ModifiersIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.OverriddenMethodsIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ParameterCountIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ParameterTypesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ParameterTypesStructuralIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ProjectNameIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.QualifiedNameIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ResourcePathIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ReturnTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.SimpleNameIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.TimestampIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedFieldsInFinallyIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedFieldsInTryIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedMethodsInFinallyIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedMethodsInTryIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedMethodsIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedTypesInFinallyIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedTypesInTryIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.UsedTypesIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.VariableDefinitionIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.VariableNameIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.VariableParameterUsageIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.VariableTargetUsageIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.VariableTypeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.strategy.IFieldIndexingStrategy;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.strategy.SimpleNameBasedStrategy;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.utils.IIndexInformationProvider;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.utils.IndexInformationCache;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor.CompilationUnitVisitor;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.CodeSearcher;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.rcp.utils.Logs;

public class CodeIndexer
implements ICompilationUnitIndexer {
    private static boolean verbose = false;
    private static final List<IIndexer> DEFAULT_INDEXER = CodeIndexer.getDefaultIndexer();
    private static IFieldIndexingStrategy indexingFieldInfoProvider = new SimpleNameBasedStrategy();
    private final IndexWriter writer;
    private final CodeSearcher searcher;
    private final List<IIndexer> tmpIndexerCollection = Lists.newArrayList();
    private final IIndexInformationProvider indexInformationProvider;

    public static void setVerbose(boolean value) {
        verbose = value;
    }

    public static void setIndexingFieldInformationProvider(IFieldIndexingStrategy newIindexingFieldInfoProvider) {
        indexingFieldInfoProvider = newIindexingFieldInfoProvider;
    }

    public static void addFieldToDocument(Document document, String fieldName, int fieldValue) {
        CodeIndexer.addFieldToDocument(document, fieldName, String.valueOf(fieldValue));
    }

    public static void addFieldToDocument(Document document, String fieldName, String fieldValue) {
        CodeIndexer.addInternal(document, fieldName, fieldValue, indexingFieldInfoProvider.getStore(fieldName), indexingFieldInfoProvider.getIndex(fieldName));
    }

    private static void addInternal(Document document, String fieldName, String fieldValue, Field.Store store, Field.Index index) {
        if (fieldValue == null) {
            return;
        }
        if (verbose) {
            System.out.println(String.format("Indexed field [%30s]=[%60s]", fieldName, fieldValue));
        }
        Field field = new Field(fieldName, fieldValue, store, index);
        document.add((Fieldable)field);
    }

    @Inject
    public CodeIndexer(IndexWriter writer, CodeSearcher searcher) throws IOException {
        this.writer = writer;
        this.searcher = searcher;
        this.indexInformationProvider = new IndexInformationCache();
    }

    @Override
    public void index(CompilationUnit cu) throws IOException {
        this.index(cu, new CodeIndexerDefaultConfigBean());
    }

    @Override
    public void index(CompilationUnit cu, CodeIndexerConfigBean settings) throws IOException {
        this.index(cu, settings, DEFAULT_INDEXER);
    }

    @Override
    public void index(CompilationUnit cu, IIndexer indexer) throws IOException {
        this.tmpIndexerCollection.clear();
        this.tmpIndexerCollection.add(indexer);
        this.index(cu, this.tmpIndexerCollection);
    }

    @Override
    public void index(CompilationUnit cu, List<IIndexer> indexer) throws IOException {
        this.index(cu, new CodeIndexerDefaultConfigBean(), indexer);
    }

    private void index(CompilationUnit cu, CodeIndexerConfigBean settings, List<IIndexer> indexer) throws IOException {
        if (settings.isDeleteDocumentFirst()) {
            this.delete(cu);
        }
        CompilationUnitVisitor visitor = new CompilationUnitVisitor(this, settings);
        visitor.addIndexer(indexer);
        try {
            cu.accept((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Exception while indexing %s", (Object[])new Object[]{ResourcePathIndexer.getFile(cu)});
        }
        this.indexInformationProvider.setLastIndexed(ResourcePathIndexer.getFile(cu), TimestampIndexer.getTime());
    }

    @Override
    public long lastIndexed(File location) {
        Optional<Long> lastIndexed = this.indexInformationProvider.getLastIndexed(location);
        if (lastIndexed.isPresent()) {
            return (Long)lastIndexed.get();
        }
        lastIndexed = this.lastIndexedInternal(location);
        if (lastIndexed.isPresent()) {
            this.indexInformationProvider.setLastIndexed(location, (Long)lastIndexed.get());
            return (Long)lastIndexed.get();
        }
        return 0L;
    }

    private Optional<Long> lastIndexedInternal(File location) {
        try {
            TermQuery query = new TermQuery(CodeSearcher.prepareSearchTerm("ResourcePath", ResourcePathIndexer.getPath(location)));
            SetBasedFieldSelector selector = new SetBasedFieldSelector((Set)Sets.newHashSet((Object[])new String[]{"Timestamp"}), (Set)Sets.newHashSet());
            List<Document> docs = this.searcher.search((Query)query, (FieldSelector)selector, 1);
            if (docs.size() > 0) {
                return this.getMinTimestamp(docs);
            }
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"failed to fetch last indexed timestamp for CU from code-search index.", (Object[])new Object[0]);
        }
        return Optional.absent();
    }

    private Optional<Long> getMinTimestamp(List<Document> documents) {
        long min = Long.MAX_VALUE;
        for (Document doc : documents) {
            String timestampString = doc.get("Timestamp");
            try {
                Long timestampValue = Long.parseLong(timestampString);
                if (min <= timestampValue) continue;
                min = timestampValue;
            }
            catch (Exception exception) {}
        }
        if (min == Long.MAX_VALUE) {
            return Optional.absent();
        }
        return Optional.of((Object)min);
    }

    public void delete(File location) throws IOException {
        this.delete(CodeSearcher.prepareSearchTerm("ResourcePath", ResourcePathIndexer.getPath(location)));
    }

    public void delete(Term term) throws IOException {
        if (term == null || term.text() == null) {
            return;
        }
        TermQuery q = new TermQuery(CodeSearcher.prepareSearchTerm(term.field(), term.text().toLowerCase()));
        this.writer.deleteDocuments((Query)q);
    }

    @Override
    public void delete(CompilationUnit cu) throws IOException {
        String cuPath = ResourcePathIndexer.getPath(cu);
        this.delete(CodeSearcher.prepareSearchTerm("ResourcePath", cuPath));
    }

    public void commit() {
        try {
            this.writer.commit();
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"failed to commit latest changes to code-search index.", (Object[])new Object[0]);
        }
    }

    public void compact(boolean wait) {
        try {
            this.writer.forceMerge(10, true);
            this.writer.commit();
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"failed to compact code-search index.", (Object[])new Object[0]);
        }
    }

    public void addDocument(Document d) throws IOException {
        this.writer.addDocument(d);
    }

    @Override
    public void truncateIndex() {
        try {
            this.writer.deleteAll();
            this.writer.commit();
        }
        catch (IOException e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"failed to truncate code-search index.", (Object[])new Object[0]);
        }
    }

    public void printStats() {
    }

    @Override
    public void close() {
        try {
            this.commit();
            this.writer.close();
        }
        catch (Exception ex) {
            Logs.logError((Throwable)ex, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"failed to close code-search index.", (Object[])new Object[0]);
        }
    }

    public void addDocuments(List<Document> docs) throws IOException {
        for (Document doc : docs) {
            this.addDocument(doc);
        }
    }

    public static List<IIndexer> getDefaultIndexer() {
        ArrayList list = Lists.newArrayList();
        list.add(new AllDeclaredFieldNamesIndexer());
        list.add(new AllDeclaredMethodNamesIndexer());
        list.add(new AllExtendedTypesIndexer());
        list.add(new AllImplementedInterfacesIndexer());
        list.add(new AnnotationsIndexer());
        list.add(new CaughtTypeIndexer());
        list.add(new CheckedExceptionsIndexer());
        list.add(new DeclaredFieldNamesIndexer());
        list.add(new DeclaredFieldTypesIndexer());
        list.add(new DeclaredMethodNamesIndexer());
        list.add(new DeclaredMethodsIndexer());
        list.add(new DeclaringMethodIndexer());
        list.add(new DeclaringTypeIndexer());
        list.add(new DocumentTypeIndexer());
        list.add(new ExtendedTypeIndexer());
        list.add(new FieldsReadIndexer());
        list.add(new FieldsWrittenIndexer());
        list.add(new FieldTypeIndexer());
        list.add(new SimpleNameIndexer());
        list.add(new FullTextIndexer());
        list.add(new FullTextIndexer2());
        list.add(new QualifiedNameIndexer());
        list.add(new ImplementedInterfacesIndexer());
        list.add(new InstanceOfIndexer());
        list.add(new ModifiersIndexer());
        list.add(new OverriddenMethodsIndexer());
        list.add(new ParameterCountIndexer());
        list.add(new ParameterTypesIndexer());
        list.add(new ParameterTypesStructuralIndexer());
        list.add(new ProjectNameIndexer());
        list.add(new ResourcePathIndexer());
        list.add(new ReturnTypeIndexer());
        list.add(new TimestampIndexer());
        list.add(new UsedFieldsInFinallyIndexer());
        list.add(new UsedFieldsInTryIndexer());
        list.add(new UsedMethodsIndexer());
        list.add(new UsedMethodsInFinallyIndexer());
        list.add(new UsedMethodsInTryIndexer());
        list.add(new UsedTypesIndexer());
        list.add(new UsedTypesInFinallyIndexer());
        list.add(new UsedTypesInTryIndexer());
        list.add(new VariableDefinitionIndexer());
        list.add(new VariableNameIndexer());
        list.add(new VariableParameterUsageIndexer());
        list.add(new VariableTargetUsageIndexer());
        list.add(new VariableTypeIndexer());
        list.add(new JavaElementHandleIndexer());
        return list;
    }
}

