/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;

public class DeclaredFieldNamesIndexer
implements IClassIndexer,
IMethodIndexer,
ITryCatchBlockIndexer {
    @Override
    public void indexMethod(final Document document, MethodDeclaration method) {
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                DeclaredFieldNamesIndexer.this.addVariableNames(document, node);
                return false;
            }
        };
        method.accept(visitor);
    }

    @Override
    public void indexType(final Document document, TypeDeclaration type) {
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                DeclaredFieldNamesIndexer.this.addVariableNames(document, node);
                return false;
            }
        };
        type.accept(visitor);
    }

    @Override
    public void indexTryCatchBlock(final Document document, TryStatement tryStatement, CatchClause catchClause) {
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                DeclaredFieldNamesIndexer.this.addVariableNames(document, node);
                return false;
            }
        };
        catchClause.accept(visitor);
    }

    protected void addVariableNames(Document document, VariableDeclarationStatement node) {
        for (VariableDeclarationFragment f : node.fragments()) {
            SimpleName name = f.getName();
            CodeIndexer.addFieldToDocument(document, "DeclaredFieldNames", name.getIdentifier());
        }
    }

    protected void addVariableNames(Document document, FieldDeclaration node) {
        for (VariableDeclarationFragment f : node.fragments()) {
            SimpleName name = f.getName();
            CodeIndexer.addFieldToDocument(document, "DeclaredFieldNames", name.getIdentifier());
        }
    }
}

