/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AstHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IVarUsageIndexer;

public class DeclaringTypeIndexer
implements IFieldIndexer,
IMethodIndexer,
IClassIndexer,
ITryCatchBlockIndexer,
IVarUsageIndexer {
    @Override
    public void indexType(Document document, TypeDeclaration type) {
        this.addFieldForParentTypes(document, (ASTNode)type);
    }

    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        this.addFieldForParentTypes(document, (ASTNode)method);
    }

    @Override
    public void indexField(Document document, FieldDeclaration field) {
        this.addFieldForParentTypes(document, (ASTNode)field);
    }

    @Override
    public void indexVarUsage(Document document, MethodDeclaration method, SimpleName name) {
        this.addFieldForParentTypes(document, (ASTNode)method);
    }

    @Override
    public void indexTryCatchBlock(Document document, TryStatement tryStatement, CatchClause catchClause) {
        this.addFieldForParentTypes(document, (ASTNode)tryStatement);
    }

    private void addFieldForParentTypes(Document document, ASTNode n) {
        Optional<String> opt = BindingHelper.getIdentifier(AstHelper.getDeclaringType(n.getParent()));
        if (opt.isPresent()) {
            CodeIndexer.addFieldToDocument(document, "DeclaringType", (String)opt.get());
        }
    }
}

