/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;

public class ExtendedTypeIndexer
implements IClassIndexer {
    @Override
    public void indexType(Document document, TypeDeclaration type) {
        ITypeBinding clazz = type.resolveBinding();
        if (clazz != null) {
            this.addAnalyzedExtendedTypeField(document, clazz, "ExtendedTypes");
        }
    }

    protected void addAnalyzedExtendedTypeField(Document document, ITypeBinding typeBinding, String fieldName) {
        ITypeBinding superclass = typeBinding.getSuperclass();
        Optional<String> opt = BindingHelper.getIdentifier(superclass);
        if (opt.isPresent()) {
            CodeIndexer.addFieldToDocument(document, fieldName, (String)opt.get());
        }
    }
}

