/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;

public class InstanceOfIndexer
implements IMethodIndexer,
ITryCatchBlockIndexer,
IClassIndexer {
    @Override
    public void indexType(Document document, TypeDeclaration type) {
        InstanceOfVisitor visitor = new InstanceOfVisitor(document);
        type.accept((ASTVisitor)visitor);
    }

    @Override
    public void indexTryCatchBlock(Document document, TryStatement tryStatement, CatchClause catchClause) {
        InstanceOfVisitor visitor = new InstanceOfVisitor(document);
        catchClause.accept((ASTVisitor)visitor);
    }

    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        InstanceOfVisitor visitor = new InstanceOfVisitor(document);
        method.accept((ASTVisitor)visitor);
    }

    private class InstanceOfVisitor
    extends ASTVisitor {
        private final Document document;

        public InstanceOfVisitor(Document document) {
            this.document = document;
        }

        public boolean visit(InstanceofExpression node) {
            Optional<String> opt = BindingHelper.getIdentifier(node.getRightOperand());
            if (opt.isPresent()) {
                CodeIndexer.addFieldToDocument(this.document, "InstanceofTypes", (String)opt.get());
            }
            return false;
        }
    }
}

