/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import java.util.List;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IVarUsageIndexer;

public class JavaElementHandleIndexer
implements IMethodIndexer,
IClassIndexer,
IFieldIndexer,
IVarUsageIndexer {
    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        this.add(document, (IBinding)method.resolveBinding());
    }

    @Override
    public void indexType(Document document, TypeDeclaration type) {
        this.add(document, (IBinding)type.resolveBinding());
    }

    @Override
    public void indexField(Document document, FieldDeclaration field) {
        List fragments = field.fragments();
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        this.add(document, (IBinding)fragment.resolveBinding());
    }

    @Override
    public void indexVarUsage(Document document, MethodDeclaration method, SimpleName name) {
        this.add(document, (IBinding)method.resolveBinding());
    }

    private void add(Document document, IBinding b) {
        if (b == null) {
            return;
        }
        IJavaElement e = b.getJavaElement();
        if (e == null) {
            return;
        }
        String h = e.getHandleIdentifier();
        CodeIndexer.addFieldToDocument(document, "Handle", h);
    }
}

