/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;

public class ModifiersIndexer
implements IClassIndexer,
IMethodIndexer,
IFieldIndexer {
    @Override
    public void indexField(Document document, FieldDeclaration field) {
        this.addFields(document, field.getModifiers());
    }

    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        this.addFields(document, method.getModifiers());
    }

    @Override
    public void indexType(Document document, TypeDeclaration type) {
        this.addFields(document, type.getModifiers());
    }

    private void addFields(Document document, int flags) {
        if (Modifier.isPublic((int)flags)) {
            this.addField(document, "public");
        }
        if (Modifier.isFinal((int)flags)) {
            this.addField(document, "final");
        }
        if (Modifier.isPrivate((int)flags)) {
            this.addField(document, "private");
        }
        if (Modifier.isProtected((int)flags)) {
            this.addField(document, "protected");
        }
        if (Modifier.isStatic((int)flags)) {
            this.addField(document, "static");
        }
        if (Modifier.isAbstract((int)flags)) {
            this.addField(document, "abstract");
        }
    }

    private void addField(Document document, String modifier) {
        CodeIndexer.addFieldToDocument(document, "Modifiers", modifier);
    }
}

