/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;

public class OverriddenMethodsIndexer
implements IClassIndexer {
    @Override
    public void indexType(final Document document, TypeDeclaration type) {
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                IMethodBinding b = node.resolveBinding();
                OverriddenMethodsIndexer.this.setOverriddenMethodName(document, b);
                return false;
            }
        };
        type.accept(visitor);
    }

    private void setOverriddenMethodName(Document document, IMethodBinding b) {
        if (b == null) {
            return;
        }
        IMethodBinding overriddenBinding = Bindings.findOverriddenMethod((IMethodBinding)b, (boolean)true);
        Optional<String> opt = BindingHelper.getIdentifier(overriddenBinding);
        if (opt.isPresent()) {
            CodeIndexer.addFieldToDocument(document, "OverriddenMethods", (String)opt.get());
        }
    }
}

