/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AstHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;

public class QualifiedNameIndexer
implements IMethodIndexer,
IClassIndexer,
IFieldIndexer {
    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        Optional<String> opt = BindingHelper.getIdentifier(method);
        if (opt.isPresent()) {
            CodeIndexer.addFieldToDocument(document, "FullyQualifiedName", (String)opt.get());
        }
    }

    @Override
    public void indexType(Document document, TypeDeclaration type) {
        Optional<String> opt = BindingHelper.getIdentifier(type);
        if (opt.isPresent()) {
            CodeIndexer.addFieldToDocument(document, "FullyQualifiedName", (String)opt.get());
        }
    }

    @Override
    public void indexField(Document document, FieldDeclaration field) {
        Optional<String> opt = BindingHelper.getIdentifier(AstHelper.getDeclaringType((ASTNode)field));
        if (opt.isPresent()) {
            List fragments = field.fragments();
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            CodeIndexer.addFieldToDocument(document, "FullyQualifiedName", String.valueOf((String)opt.get()) + "." + fragment.getName());
        }
    }
}

