/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import org.apache.lucene.document.Document;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IVarUsageIndexer;
import org.eclipse.recommenders.utils.Checks;

public class ResourcePathIndexer
implements IClassIndexer,
IMethodIndexer,
ITryCatchBlockIndexer,
IFieldIndexer,
IVarUsageIndexer {
    public static String getPath(IJavaElement e) {
        return ResourcePathIndexer.getPath(ResourcePathIndexer.getFile(e));
    }

    public static File getFile(IJavaElement e) {
        IPath path;
        IResource resource = e.getResource();
        if (resource == null) {
            path = e.getPath();
        } else {
            URI uri;
            path = resource.getRawLocation();
            if (path == null && (uri = resource.getLocationURI()) != null) {
                return new File(uri);
            }
        }
        return path.toFile();
    }

    public static String getPath(CompilationUnit cu) {
        return ResourcePathIndexer.getPath(ResourcePathIndexer.getFile(cu));
    }

    public static File getFile(CompilationUnit cu) {
        ITypeRoot root = cu.getTypeRoot();
        if (root == null) {
            return (File)Checks.ensureIsNotNull((Object)((File)cu.getProperty("location")));
        }
        return ResourcePathIndexer.getFile((IJavaElement)root);
    }

    public static String getPath(File file) {
        return file.getAbsolutePath();
    }

    @VisibleForTesting
    public static String escape(String path) {
        String fileName = path;
        fileName = fileName.replaceAll("\\\\", "\\\\\\\\");
        fileName = fileName.replaceAll(":", "\\\\:");
        fileName = fileName.replaceAll("-", "\\\\-");
        return fileName;
    }

    @Override
    public void indexField(Document document, FieldDeclaration field) {
        this.addField(document, (ASTNode)field);
    }

    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        this.addField(document, (ASTNode)method);
    }

    @Override
    public void indexType(Document document, TypeDeclaration type) {
        this.addField(document, (ASTNode)type);
    }

    @Override
    public void indexTryCatchBlock(Document document, TryStatement tryStatement, CatchClause catchClause) {
        this.addField(document, (ASTNode)tryStatement);
    }

    @Override
    public void indexVarUsage(Document document, MethodDeclaration method, SimpleName name) {
        this.addField(document, (ASTNode)method);
    }

    private void addField(Document document, ASTNode node) {
        CompilationUnit cu = (CompilationUnit)node.getRoot();
        File f = ResourcePathIndexer.getFile(cu);
        CodeIndexer.addFieldToDocument(document, "ResourcePath", f.getAbsolutePath());
    }
}

