/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AstHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;

public class ReturnTypeIndexer
implements IMethodIndexer {
    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        Type returnType = method.getReturnType2();
        this.addReturnsVoidField(document, returnType);
        this.addReturnsTypeField(document, returnType);
    }

    private void addReturnsVoidField(Document document, Type returnType) {
        if (AstHelper.isVoid(returnType)) {
            CodeIndexer.addFieldToDocument(document, "ReturnType", "Lvoid");
        }
    }

    private void addReturnsTypeField(Document document, Type returnType) {
        Optional<String> opt = BindingHelper.getIdentifier(returnType);
        if (opt.isPresent() && !((String)opt.get()).equals("V")) {
            CodeIndexer.addFieldToDocument(document, "ReturnType", (String)opt.get());
        }
    }
}

