/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;

public class TimestampIndexer
implements IClassIndexer,
IMethodIndexer,
IFieldIndexer,
ITryCatchBlockIndexer {
    private static long currentTimestamp = 0L;

    @Override
    public void indexTryCatchBlock(Document document, TryStatement tryStatement, CatchClause catchClause) {
        CodeIndexer.addFieldToDocument(document, "Timestamp", TimestampIndexer.getTimeString());
    }

    @Override
    public void indexField(Document document, FieldDeclaration field) {
        CodeIndexer.addFieldToDocument(document, "Timestamp", TimestampIndexer.getTimeString());
    }

    @Override
    public void indexMethod(Document document, MethodDeclaration method) {
        CodeIndexer.addFieldToDocument(document, "Timestamp", TimestampIndexer.getTimeString());
    }

    @Override
    public void indexType(Document document, TypeDeclaration type) {
        CodeIndexer.addFieldToDocument(document, "Timestamp", TimestampIndexer.getTimeString());
    }

    public static String getTimeString() {
        long timestamp = TimestampIndexer.getTime();
        return String.valueOf(timestamp);
    }

    public static void updateCurrentTimestamp() {
        currentTimestamp = System.currentTimeMillis();
    }

    public static long getTime() {
        TimestampIndexer.updateCurrentTimestamp();
        return currentTimestamp;
    }
}

