/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor.MethodCallVisitor;

public class UsedMethodsIndexer
implements IClassIndexer,
IMethodIndexer,
ITryCatchBlockIndexer {
    @Override
    public void indexMethod(final Document document, MethodDeclaration method) {
        MethodCallVisitor visitor = new MethodCallVisitor(){

            @Override
            protected void handleMethodCall(IMethodBinding methodBinding) {
                Optional<String> opt = BindingHelper.getIdentifier(methodBinding);
                if (opt.isPresent()) {
                    CodeIndexer.addFieldToDocument(document, "UsedMethods", (String)opt.get());
                }
            }
        };
        method.accept((ASTVisitor)visitor);
    }

    @Override
    public void indexType(final Document document, TypeDeclaration type) {
        MethodCallVisitor visitor = new MethodCallVisitor(){

            @Override
            protected void handleMethodCall(IMethodBinding methodBinding) {
                Optional<String> opt = BindingHelper.getIdentifier(methodBinding);
                if (opt.isPresent()) {
                    CodeIndexer.addFieldToDocument(document, "UsedMethods", (String)opt.get());
                }
            }
        };
        type.accept((ASTVisitor)visitor);
    }

    @Override
    public void indexTryCatchBlock(final Document document, TryStatement tryStatement, CatchClause catchClause) {
        MethodCallVisitor visitor = new MethodCallVisitor(){

            @Override
            protected void handleMethodCall(IMethodBinding methodBinding) {
                Optional<String> opt = BindingHelper.getIdentifier(methodBinding);
                if (opt.isPresent()) {
                    CodeIndexer.addFieldToDocument(document, "UsedMethods", (String)opt.get());
                }
            }
        };
        catchClause.accept((ASTVisitor)visitor);
    }
}

