/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer;

import com.google.common.base.Optional;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.BindingHelper;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor.TypeUseVisitor;

public class UsedTypesInFinallyIndexer
implements ITryCatchBlockIndexer {
    @Override
    public void indexTryCatchBlock(final Document document, TryStatement tryStatement, CatchClause catchClause) {
        TypeUseVisitor visitor = new TypeUseVisitor(){

            @Override
            protected void handleTypeUse(ITypeBinding typeBinding) {
                UsedTypesInFinallyIndexer.this.addUsedType(document, typeBinding);
            }
        };
        if (tryStatement.getFinally() != null) {
            tryStatement.getFinally().accept((ASTVisitor)visitor);
        }
    }

    private void addUsedType(Document document, ITypeBinding typeBinding) {
        Optional<String> opt = BindingHelper.getIdentifier(typeBinding);
        if (opt.isPresent()) {
            CodeIndexer.addFieldToDocument(document, "UsedTypesInFinally", (String)opt.get());
        }
    }
}

