/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer.analyzer;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.eclipse.recommenders.codesearch.rcp.index.tokenizers.CamelCaseTokenizer;
import org.eclipse.recommenders.codesearch.rcp.index.tokenizers.DotSplitTokenizer;

public class JavaSourceCodeAnalyzer
extends Analyzer {
    private Set<Object> javaSourceCodeStopSet = StopFilter.makeStopSet((Version)Version.LUCENE_35, (String[])new String[]{"abstract", "final", "private", "protected", "public", "static", "interface", "implements", "extends", "null", "new", "switch", "case", "default", "synchronized", "do", "if", "else", "break", "continue", "this", "assert", "for", "instanceof", "transient", "void", "finally", "catch", "return", "throws", "throw", "class", "while", "import", "package", "true", "false"});

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Version version = Version.LUCENE_35;
        Object resultTokenStream = new StandardTokenizer(version, reader);
        resultTokenStream = new StopFilter(version, (TokenStream)resultTokenStream, this.javaSourceCodeStopSet);
        resultTokenStream = new DotSplitTokenizer((TokenStream)resultTokenStream);
        resultTokenStream = new CamelCaseTokenizer((TokenStream)resultTokenStream);
        resultTokenStream = new LowerCaseFilter(version, (TokenStream)resultTokenStream);
        return resultTokenStream;
    }
}

