/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer.strategy;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.strategy.IFieldIndexingStrategy;

public class SimpleNameBasedStrategy
implements IFieldIndexingStrategy {
    private Map<String, Field.Store> storeMap = Maps.newHashMap();
    private Map<String, Field.Index> indexMap = Maps.newHashMap();
    private Object helperObj = null;

    public SimpleNameBasedStrategy() {
        this.storeMap.put("Type", Field.Store.YES);
        this.storeMap.put("Timestamp", Field.Store.YES);
        this.storeMap.put("VariableName", Field.Store.YES);
        this.storeMap.put("FullyQualifiedName", Field.Store.YES);
        this.storeMap.put("DeclaringType", Field.Store.YES);
        this.storeMap.put("DeclaringMethod", Field.Store.YES);
        this.storeMap.put("Handle", Field.Store.YES);
        this.storeMap.put("ParameterTypesStructural", Field.Store.YES);
        this.storeMap.put("UsedAsParameterInMethods", Field.Store.YES);
        this.indexMap.put("Timestamp", Field.Index.NO);
        this.indexMap.put("Handle", Field.Index.NO);
    }

    @Override
    public Field.Store getStore(String fieldName) {
        return this.getValueOrDefault(fieldName, this.storeMap, Field.Store.NO);
    }

    @Override
    public Field.Index getIndex(String fieldName) {
        return this.getValueOrDefault(fieldName, this.indexMap, Field.Index.ANALYZED);
    }

    private <T> T getValueOrDefault(String fieldName, Map<String, T> map, T defaultValue) {
        this.helperObj = map.get(fieldName);
        if (this.helperObj != null) {
            return (T)this.helperObj;
        }
        return defaultValue;
    }
}

