/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer.utils;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.utils.IIndexInformationProvider;

public class IndexInformationCache
implements IIndexInformationProvider {
    private final Cache<File, Long> cache = CacheBuilder.newBuilder().maximumSize(3000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Override
    public Optional<Long> getLastIndexed(File location) {
        if (this.cache.asMap().containsKey(location)) {
            return Optional.of((Object)((Long)this.cache.getIfPresent((Object)location)));
        }
        return Optional.absent();
    }

    @Override
    public void setLastIndexed(File location, Long lastIndexed) {
        this.cache.put((Object)location, (Object)lastIndexed);
    }
}

