/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexerConfigBean;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexerDefaultConfigBean;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IClassIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IFieldIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IMethodIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.ITryCatchBlockIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor.VarUsageVisitor;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.rcp.utils.Logs;

public class CompilationUnitVisitor
extends ASTVisitor {
    private CodeIndexer index = null;
    private final List<IIndexer> indexer;
    private CodeIndexerConfigBean settings;

    public void addIndexer(IIndexer indexer) {
        this.indexer.add(indexer);
    }

    public void addIndexer(Collection<IIndexer> indexer) {
        this.indexer.addAll(indexer);
    }

    public CompilationUnitVisitor(CodeIndexer index) {
        this(index, new CodeIndexerDefaultConfigBean());
    }

    public CompilationUnitVisitor(CodeIndexer index, CodeIndexerConfigBean settings) {
        this.index = index;
        this.indexer = Lists.newArrayList();
        this.settings = settings;
    }

    public boolean visit(TypeDeclaration node) {
        Document document = new Document();
        for (IIndexer i : this.indexer) {
            if (!(i instanceof IClassIndexer)) continue;
            ((IClassIndexer)i).indexType(document, node);
        }
        this.addDocument(document);
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        Document methodDocument = new Document();
        for (IIndexer i : this.indexer) {
            if (!(i instanceof IMethodIndexer)) continue;
            ((IMethodIndexer)i).indexMethod(methodDocument, node);
        }
        if (methodDocument.getFields().size() > 0) {
            this.addDocument(methodDocument);
        }
        VarUsageVisitor varUsageVisitor = new VarUsageVisitor(this.indexer);
        varUsageVisitor.visit(node);
        for (Document d : varUsageVisitor.getDocuments()) {
            if (d.getFields().size() <= 0) continue;
            this.addDocument(d);
        }
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        Document document = new Document();
        for (IIndexer i : this.indexer) {
            if (!(i instanceof IFieldIndexer)) continue;
            ((IFieldIndexer)i).indexField(document, node);
        }
        if (document.getFields().size() > 0) {
            this.addDocument(document);
        }
        return false;
    }

    public boolean visit(TryStatement node) {
        Document document = new Document();
        TryStatement tryStatement = node;
        List catchClauses = tryStatement.catchClauses();
        for (CatchClause catchClause : catchClauses) {
            for (IIndexer i : this.indexer) {
                if (!(i instanceof ITryCatchBlockIndexer)) continue;
                ((ITryCatchBlockIndexer)i).indexTryCatchBlock(document, tryStatement, catchClause);
            }
        }
        if (document.getFields().size() > 0) {
            this.addDocument(document);
        }
        return false;
    }

    private void addDocument(Document document) {
        try {
            document.setBoost(this.settings.getDocumentBoost());
            this.index.addDocument(document);
        }
        catch (IOException e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Exception during document save.", (Object[])new Object[0]);
        }
    }
}

