/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.AstHelper;
import org.eclipse.recommenders.rcp.utils.AstBindings;
import org.eclipse.recommenders.utils.names.ITypeName;

public abstract class TypeUseVisitor
extends ASTVisitor {
    public boolean visit(SimpleType node) {
        try {
            ITypeBinding b = node.resolveBinding();
            this.handleTypeUseInternal(b);
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public boolean visit(QualifiedType node) {
        ITypeBinding b = node.resolveBinding();
        this.handleTypeUseInternal(b);
        return false;
    }

    public boolean visit(SimpleName node) {
        IBinding b = node.resolveBinding();
        if (b instanceof ITypeBinding) {
            this.handleTypeUseInternal((ITypeBinding)b);
        } else if (b instanceof IVariableBinding) {
            IVariableBinding var = (IVariableBinding)b;
            this.handleTypeUseInternal(var.getType());
        }
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        ITypeBinding typeBinding = node.getType().resolveBinding();
        this.handleTypeUseInternal(typeBinding);
        return false;
    }

    public boolean visit(MethodInvocation node) {
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        return false;
    }

    public boolean visit(TryStatement node) {
        return true;
    }

    private void handleTypeUseInternal(ITypeBinding typeBinding) {
        ITypeName typeName = (ITypeName)AstBindings.toTypeName((ITypeBinding)typeBinding).orNull();
        if (!AstHelper.isPrimitiveOrArrayOrNullOrObjectOrString(typeName)) {
            this.handleTypeUse(typeBinding);
        }
    }

    protected void handleTypeUse(ITypeBinding typeBinding) {
    }
}

