/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.indexer.visitor;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.lucene.document.Document;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.interfaces.IVarUsageIndexer;

public class VarUsageVisitor {
    private List<IIndexer> indexer;
    private MethodDeclaration method;
    private final List<Document> documents = Lists.newArrayList();
    private ASTVisitor visitor = new ASTVisitor(){

        public boolean visit(SingleVariableDeclaration node) {
            VarUsageVisitor.this.process(VarUsageVisitor.this.method, node.getName());
            return true;
        }

        public boolean visit(VariableDeclarationFragment node) {
            VarUsageVisitor.this.process(VarUsageVisitor.this.method, node.getName());
            return true;
        }
    };

    public VarUsageVisitor(List<IIndexer> indexer) {
        this.indexer = indexer;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void visit(MethodDeclaration method) {
        this.method = method;
        method.accept(this.visitor);
    }

    private void process(MethodDeclaration method, SimpleName name) {
        Document varUsageDocument = new Document();
        for (IIndexer i : this.indexer) {
            if (!(i instanceof IVarUsageIndexer)) continue;
            ((IVarUsageIndexer)i).indexVarUsage(varUsageDocument, method, name);
        }
        this.documents.add(varUsageDocument);
    }
}

