/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.searcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.recommenders.codesearch.rcp.index.searcher.SearchResult;
import org.eclipse.recommenders.codesearch.rcp.index.termvector.ITermVectorConsumable;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.rcp.utils.Logs;
import org.eclipse.recommenders.utils.Checks;

@Singleton
public class CodeSearcher
implements ITermVectorConsumable {
    private final QueryParser parser;
    private IndexSearcher searcher;
    private IndexReader reader;

    @Inject
    public CodeSearcher(IndexSearcher searcher, IndexReader reader, QueryParser parser) throws IOException {
        this.parser = parser;
        this.searcher = searcher;
        this.reader = reader;
    }

    @VisibleForTesting
    public List<Document> getDocuments() throws IOException {
        MatchAllDocsQuery allDocsQuery = new MatchAllDocsQuery();
        return this.search((Query)allDocsQuery, null);
    }

    public List<Document> search(String queryString) throws IOException, ParseException {
        return this.search(queryString, null);
    }

    public List<Document> search(String queryString, FieldSelector selector) throws IOException, ParseException {
        Query query = this.parser.parse(queryString);
        return this.search(query, selector);
    }

    public List<Document> search(Query query, FieldSelector selector) throws IOException {
        this.renewReader();
        return this.search(query, selector, this.reader.numDocs() + 1);
    }

    public List<Document> search(Query query, FieldSelector selector, int maxHits) throws IOException {
        SearchResult searchResult = this.lenientSearch(query, maxHits);
        List<Document> result = this.toList(searchResult.scoreDocs(), selector);
        return result;
    }

    public SearchResult lenientSearch(String queryString) throws IOException, ParseException {
        this.renewReader();
        Query query = this.parser.parse(queryString);
        TopDocs docs = this.searcher.search(query, this.reader.numDocs() + 1);
        return new SearchResult(query, docs, this.searcher);
    }

    public SearchResult lenientSearch(Query query) throws IOException {
        this.renewReader();
        TopDocs docs = this.searcher.search(query, this.reader.numDocs() + 1);
        return new SearchResult(query, docs, this.searcher);
    }

    public SearchResult lenientSearch(Query query, int maxHits) throws IOException {
        Checks.ensureIsGreaterOrEqualTo((double)maxHits, (double)1.0, (String)"max hits must be greater zero");
        this.renewReader();
        TopDocs docs = this.searcher.search(query, maxHits);
        return new SearchResult(query, docs, this.searcher);
    }

    @Override
    public Set<String> getTermVector(String[] fieldNames) {
        this.renewReader();
        HashSet result = Sets.newHashSet();
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            try {
                Object[] values = FieldCache.DEFAULT.getStringIndex((IndexReader)this.reader, (String)field).lookup;
                result.addAll(Lists.newArrayList((Object[])values));
            }
            catch (IOException e) {
                Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Exception during reopening of index reader", (Object[])new Object[0]);
            }
            ++n2;
        }
        result.remove(null);
        return result;
    }

    private void renewReader() {
        try {
            IndexReader newReader = IndexReader.openIfChanged((IndexReader)this.reader);
            if (newReader != null) {
                this.reader.close();
                this.searcher.close();
                this.reader = newReader;
                this.searcher = new IndexSearcher(this.reader);
            }
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Exception during reopening of index reader", (Object[])new Object[0]);
        }
    }

    private List<Document> toList(ScoreDoc[] scoreDocs, FieldSelector selector) throws CorruptIndexException, IOException {
        ArrayList<Document> result = new ArrayList<Document>(scoreDocs.length);
        ScoreDoc[] scoreDocArray = scoreDocs;
        int n = scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc doc = scoreDocArray[n2];
            if (selector != null) {
                result.add(this.searcher.doc(doc.doc, selector));
            } else {
                result.add(this.searcher.doc(doc.doc));
            }
            ++n2;
        }
        return result;
    }

    public Document getDocument(int docId) throws CorruptIndexException, IOException {
        return this.searcher.doc(docId);
    }

    public QueryParser getParser() {
        return this.parser;
    }

    public int getDocCount(Term t) throws IOException {
        return this.reader.docFreq(t);
    }

    public static Term prepareSearchTerm(String field, String value) {
        return new Term(field, value.toLowerCase());
    }
}

