/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.searcher;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class SearchResult {
    private boolean allDocumentsLoaded = false;
    private List<Document> loadedDocs;
    public final Query query;
    public final TopDocs docs;
    public final IndexSearcher searcher;

    public SearchResult(Query query, TopDocs docs, IndexSearcher searcher) {
        this.query = query;
        this.docs = docs;
        this.searcher = searcher;
    }

    public ScoreDoc[] scoreDocs() {
        return this.docs.scoreDocs;
    }

    public Document scoreDoc(int index) throws CorruptIndexException, IOException {
        ScoreDoc scoreDoc = this.docs.scoreDocs[index];
        return this.searcher.doc(scoreDoc.doc);
    }

    public List<Document> getAllDocuments() throws CorruptIndexException, IOException {
        if (this.allDocumentsLoaded) {
            return this.loadedDocs;
        }
        this.loadedDocs = Lists.newArrayList();
        int i = 0;
        while (i < this.docs.totalHits) {
            this.loadedDocs.add(this.searcher.doc(i));
            ++i;
        }
        this.allDocumentsLoaded = true;
        return this.loadedDocs;
    }
}

