/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.codesearch.rcp.index.searcher;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class SearchResultHelper {
    public static TopDocs getIntersection(List<TopDocs> validScoreDocs, IndexSearcher searcher) {
        if (validScoreDocs.size() == 0) {
            return new TopDocs(0, new ScoreDoc[0], 0.0f);
        }
        TopDocs result = validScoreDocs.get(0);
        int i = 1;
        while (i < validScoreDocs.size()) {
            result = SearchResultHelper.getIntersection(result, validScoreDocs.get(i), searcher);
            ++i;
        }
        return SearchResultHelper.getUniqueDocsByFieldName(result, searcher, "DeclaringMethod");
    }

    public static TopDocs getIntersection(TopDocs t1, TopDocs t2, IndexSearcher searcher) {
        ArrayList list = Lists.newArrayList();
        ScoreDoc[] scoreDocArray = t1.scoreDocs;
        int n = t1.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc d1 = scoreDocArray[n2];
            ScoreDoc[] scoreDocArray2 = t2.scoreDocs;
            int n3 = t2.scoreDocs.length;
            int n4 = 0;
            while (n4 < n3) {
                ScoreDoc d2 = scoreDocArray2[n4];
                if (SearchResultHelper.areEqual(d1, d2, searcher, "DeclaringMethod")) {
                    list.add(d1);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return SearchResultHelper.asTopDocs(list);
    }

    public static TopDocs asTopDocs(List<ScoreDoc> scoreDocs) {
        ScoreDoc[] resultDocs = new ScoreDoc[scoreDocs.size()];
        return new TopDocs(scoreDocs.size(), scoreDocs.toArray(resultDocs), 0.0f);
    }

    public static TopDocs asTopDocs(ScoreDoc[] scoreDocs) {
        return new TopDocs(scoreDocs.length, scoreDocs, 0.0f);
    }

    private static boolean areEqual(ScoreDoc d1, ScoreDoc d2, IndexSearcher searcher, String fieldName) {
        try {
            Document doc1 = searcher.doc(d1.doc);
            Document doc2 = searcher.doc(d2.doc);
            return doc1.get(fieldName) != null && doc2.get(fieldName) != null && doc1.get(fieldName).equals(doc2.get(fieldName));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static TopDocs getUniqueDocsByFieldName(TopDocs t1, IndexSearcher searcher, String fieldName) {
        HashMap docs = Maps.newHashMap();
        ScoreDoc[] scoreDocArray = t1.scoreDocs;
        int n = t1.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc d1 = scoreDocArray[n2];
            try {
                Document doc1 = searcher.doc(d1.doc);
                docs.put(doc1.get(fieldName), d1);
            }
            catch (Exception exception) {}
            ++n2;
        }
        ScoreDoc[] resultDocs = new ScoreDoc[docs.size()];
        return new TopDocs(docs.size(), docs.values().toArray(resultDocs), 0.0f);
    }
}

