/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.codesearch.rcp;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.recommenders.codesearch.rcp.index.CodeSearch;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.analyzer.JavaSourceCodeAnalyzer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.analyzer.LowerCaseKeywordAnalyzer;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.internal.codesearch.rcp.IndexUpdateService;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;

public class CodesearchIndexModule
extends AbstractModule {
    protected void configure() {
        this.configureDirectory();
        this.bind(Services.class).asEagerSingleton();
    }

    private void configureDirectory() {
        try {
            File folder = this.findOrCreateIndexFolder();
            this.deleteOldLocks(folder);
            FSDirectory directory = FSDirectory.open((File)folder);
            this.bind(Directory.class).annotatedWith(CodeSearch.class).toInstance((Object)directory);
            this.bind(Directory.class).toInstance((Object)directory);
        }
        catch (IOException e) {
            Throws.throwUnhandledException((Exception)e);
        }
    }

    private void deleteOldLocks(File folder) {
        File file = new File(folder, "write.lock");
        if (file.exists()) {
            Checks.ensureIsTrue((boolean)file.delete(), (String)"failed to remove old write lock file", (Object[])new Object[0]);
        }
    }

    private File findOrCreateIndexFolder() {
        File basedir = CodesearchIndexPlugin.getDefault().getStateLocation().toFile();
        File indexdir = new File(basedir, "index_v7");
        indexdir.mkdirs();
        return indexdir;
    }

    @Provides
    @Singleton
    public Version version() {
        return Version.LUCENE_35;
    }

    @Provides
    @Singleton
    public IndexWriter indexWriter(Version version, Analyzer analyzer, Directory directory) throws IOException {
        IndexWriterConfig config = new IndexWriterConfig(version, analyzer);
        IndexWriter.unlock((Directory)directory);
        return new IndexWriter(directory, config);
    }

    @Provides
    @Singleton
    public IndexReader indexReader(IndexWriter writer) throws IOException {
        return IndexReader.open((IndexWriter)writer, (boolean)true);
    }

    @Provides
    @Singleton
    public IndexSearcher indexSearcher(IndexReader reader) throws IOException {
        return new IndexSearcher(reader);
    }

    @Provides
    @Singleton
    public Analyzer analyzer() {
        HashMap analyzerPerField = Maps.newHashMap();
        analyzerPerField.put("FullText", new JavaSourceCodeAnalyzer());
        return new PerFieldAnalyzerWrapper((Analyzer)new LowerCaseKeywordAnalyzer(this.version()), (Map)analyzerPerField);
    }

    @Provides
    public QueryParser queryParser(Version version, Analyzer analyzer) {
        QueryParser parser = new QueryParser(version, "FullText", analyzer);
        parser.setLowercaseExpandedTerms(true);
        parser.setAllowLeadingWildcard(true);
        return parser;
    }

    @Provides
    @Singleton
    public IndexUpdateService indexUpdateService(EventBus workspaceBus, CodeIndexer indexer, IWorkspaceRoot workspace) {
        IndexUpdateService service = new IndexUpdateService(indexer, workspace);
        workspaceBus.register((Object)service);
        return service;
    }

    private static class Services {
        @Inject
        public Services(IndexUpdateService service, CodeIndexer indexer, IWorkspaceRoot workspace) {
        }
    }
}

