/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.codesearch.rcp;

import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ResourcePathIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.TimestampIndexer;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.internal.codesearch.rcp.PreferencePage;
import org.eclipse.recommenders.internal.codesearch.rcp.ProjectIndexerRunnable;
import org.eclipse.recommenders.rcp.JavaModelEvents;
import org.eclipse.recommenders.rcp.utils.Logs;
import org.eclipse.recommenders.utils.Checks;

public class IndexUpdateService {
    private static boolean backgroundIndexerActive = true;
    public static final ISchedulingRule MUTEX = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final CodeIndexer indexer;

    public static void setBackgroundIndexerActive(boolean isActive) {
        backgroundIndexerActive = isActive;
    }

    @Inject
    public IndexUpdateService(CodeIndexer indexer, IWorkspaceRoot workspace) {
        this.indexer = indexer;
        if (PreferencePage.isActive() && backgroundIndexerActive) {
            new IndexerJob("Code-search: Re-indexing workspace.", workspace.getProjects(), indexer, (Workspace)workspace.getWorkspace());
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.CompilationUnitAdded event) {
        if (PreferencePage.isActive() && backgroundIndexerActive) {
            this.tryIndexing(event.compilationUnit);
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JavaProjectOpened event) {
        if (PreferencePage.isActive() && backgroundIndexerActive) {
            IJavaProject project = event.project;
            IProject[] projects = new IProject[]{project.getProject()};
            Workspace workspace = (Workspace)Checks.cast((Object)projects[0].getWorkspace());
            String title = "Indexing " + project.getElementName();
            new IndexerJob(title, projects, this.indexer, workspace);
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.CompilationUnitSaved event) {
        if (PreferencePage.isActive() && backgroundIndexerActive) {
            this.tryIndexing(event.compilationUnit);
        }
    }

    private void tryIndexing(ICompilationUnit cu) {
        try {
            TimestampIndexer.updateCurrentTimestamp();
            ResourcePathIndexer.getFile((IJavaElement)cu);
            CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
            this.indexer.index(ast);
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Failed to index '%s'", (Object[])new Object[]{cu.getResource().getFullPath()});
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.CompilationUnitRemoved event) {
        if (!PreferencePage.isActive() || !backgroundIndexerActive) {
            return;
        }
        try {
            CompilationUnit ast;
            if (event.compilationUnit != null && (ast = SharedASTProvider.getAST((ITypeRoot)event.compilationUnit, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null)) != null) {
                this.indexer.delete(ast);
            }
        }
        catch (IOException e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"error during indexing", (Object[])new Object[0]);
        }
    }

    private final class IndexerJob
    extends Job {
        private final CodeIndexer indexer;
        private final IProject[] projects;
        private final Workspace root;
        private final ExecutorService e;

        private IndexerJob(String name, IProject[] projects, CodeIndexer indexer, Workspace workspace) {
            super(name);
            this.e = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Recommenders::codesearch-indexer-%d").setPriority(1).build());
            this.indexer = indexer;
            this.projects = projects;
            this.root = workspace;
            this.setRule(MUTEX);
            this.schedule(30000L);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (this.root.getBuildManager().isAutobuildBuildPending()) {
                this.schedule(5000L);
                return Status.CANCEL_STATUS;
            }
            final CountDownLatch wait = new CountDownLatch(1);
            this.e.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimestampIndexer.updateCurrentTimestamp();
                        monitor.beginTask("Indexing", IndexerJob.this.projects.length + 1);
                        monitor.subTask("");
                        monitor.worked(1);
                        IProject[] iProjectArray = IndexerJob.this.projects;
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject p = iProjectArray[n2];
                            if (JavaProject.hasJavaNature((IProject)p)) {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                ProjectIndexerRunnable r = new ProjectIndexerRunnable(JavaCore.create((IProject)p), IndexerJob.this.indexer);
                                SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                                try {
                                    r.run((IProgressMonitor)sub);
                                }
                                catch (Exception e) {
                                    Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Exception while indexing project '%s'", (Object[])new Object[]{p});
                                }
                            }
                            ++n2;
                        }
                    }
                    finally {
                        wait.countDown();
                    }
                }
            });
            this.e.shutdown();
            try {
                wait.await();
            }
            catch (InterruptedException interruptedException) {}
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

