/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.codesearch.rcp;

import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.lucene.document.Document;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.CodeIndexerConfigBean;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.ResourcePathIndexer;
import org.eclipse.recommenders.codesearch.rcp.index.indexer.TimestampIndexer;
import org.eclipse.recommenders.internal.codesearch.rcp.CodesearchIndexPlugin;
import org.eclipse.recommenders.rcp.utils.Logs;
import org.eclipse.recommenders.utils.Checks;

public class ProjectIndexerRunnable
implements IRunnableWithProgress {
    private final IJavaProject project;
    private final CodeIndexer indexer;
    private IPackageFragmentRoot[] roots;
    private IProgressMonitor monitor;
    IPackageFragmentRoot root;
    private File rootLocation;
    private SourceMapper sourceMapper;

    public ProjectIndexerRunnable(IJavaProject project, CodeIndexer indexer) {
        this.project = project;
        this.indexer = indexer;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.roots = this.project.getPackageFragmentRoots();
                this.monitor = monitor;
                this.openMonitor();
                IPackageFragmentRoot[] iPackageFragmentRootArray = this.roots;
                int n = this.roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    this.analyzeRoot(root);
                    ++n2;
                }
            }
            catch (Exception e) {
                Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Error during code search indexing", (Object[])new Object[0]);
                this.closeMonitor();
            }
        }
        finally {
            this.closeMonitor();
        }
    }

    private void openMonitor() {
        this.monitor.beginTask("", this.roots.length + 1);
        this.monitor.subTask("About to begin...");
        this.monitor.worked(1);
    }

    private void analyzeRoot(IPackageFragmentRoot root) throws Exception {
        this.root = root;
        this.monitor.subTask("Analyzing " + root.getElementName());
        this.rootLocation = ResourcePathIndexer.getFile((IJavaElement)root);
        if (this.monitor.isCanceled()) {
            return;
        }
        if (this.rootLocation == null) {
            return;
        }
        if (this.hasNotChanged(this.rootLocation)) {
            return;
        }
        if (root.isArchive()) {
            this.indexer.delete(this.rootLocation);
            if (!this.findSourceMapper()) {
                return;
            }
        }
        this.analyzePackageFragments();
        this.monitor.subTask("Checkpointing...");
        this.indexer.commit();
        this.monitor.worked(1);
        root.close();
    }

    private void analyzePackageFragments() throws Exception {
        for (IJavaElement child : Ordering.usingToString().sortedCopy(Arrays.asList(this.root.getChildren()))) {
            IPackageFragment fragment = (IPackageFragment)Checks.cast((Object)child);
            this.monitor.subTask("Analyzing " + fragment.getElementName());
            if (fragment.getElementName().startsWith("sun.") || fragment.getElementName().startsWith("com.sun.") || fragment.getElementName().startsWith("com.oracle.") || fragment.getElementName().startsWith("sunw.")) continue;
            for (IClassFile clazz : Ordering.usingToString().sortedCopy(Arrays.asList(fragment.getClassFiles()))) {
                this.analyzeClassFile(clazz);
            }
            ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu = iCompilationUnitArray[n2];
                this.analyzeCompilationUnit(cu);
                ++n2;
            }
            fragment.close();
        }
        this.addArchiveVisitedMarker();
    }

    private void analyzeCompilationUnit(ICompilationUnit cu) {
        try {
            File cuLocation = ResourcePathIndexer.getFile((IJavaElement)cu);
            if (this.hasNotChanged(cuLocation)) {
                return;
            }
            CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, (IProgressMonitor)this.monitor);
            if (ast == null) {
                return;
            }
            this.indexer.delete(cuLocation);
            this.indexer.index(ast, new CodeIndexerConfigBean(true, 1.5f));
        }
        catch (Exception e) {
            Logs.logError((Throwable)e, (Plugin)CodesearchIndexPlugin.getDefault(), (String)"Failed to index '%s'", (Object[])new Object[]{cu.getResource().getFullPath()});
        }
    }

    private boolean hasNotChanged(File file) {
        long lastIndexed;
        long lastModified = file.lastModified();
        return lastModified < (lastIndexed = this.indexer.lastIndexed(file));
    }

    private boolean findSourceMapper() {
        JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)this.root;
        this.sourceMapper = jarRoot.getSourceMapper();
        return this.sourceMapper != null;
    }

    private void analyzeClassFile(IClassFile clazz) throws IOException {
        if (this.monitor.isCanceled()) {
            return;
        }
        if (clazz.getElementName().contains("$")) {
            return;
        }
        IType type = clazz.getType();
        if (type == null) {
            return;
        }
        CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)clazz, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, (IProgressMonitor)this.monitor);
        if (ast == null) {
            return;
        }
        String unitName = this.root.getPath() + "!" + type.getFullyQualifiedName();
        this.monitor.subTask(unitName);
        this.indexer.index(ast, new CodeIndexerConfigBean(false, 1.0f));
    }

    private void addArchiveVisitedMarker() throws IOException {
        Document visited = new Document();
        CodeIndexer.addFieldToDocument(visited, "ResourcePath", ResourcePathIndexer.getPath(this.rootLocation));
        CodeIndexer.addFieldToDocument(visited, "Timestamp", TimestampIndexer.getTimeString());
        this.indexer.addDocument(visited);
    }

    private void closeMonitor() {
        this.monitor.done();
    }
}

