/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableCompletionProposalComputer;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.internal.completion.rcp.EmptyCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.EnableCompletionProposal;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.SharedImages;

public class IntelligentCompletionProposalComputer
extends ProcessableCompletionProposalComputer {
    private SessionProcessorDescriptor[] descriptors;
    private SharedImages images;

    @Inject
    public IntelligentCompletionProposalComputer(SessionProcessorDescriptor[] descriptors, IAstProvider astProvider, SharedImages images, Map<CompletionContextKey, ICompletionContextFunction> map) {
        super(new ProcessableProposalFactory(), Sets.newLinkedHashSet(), astProvider, map);
        this.descriptors = descriptors;
        this.images = images;
    }

    @Override
    public void sessionStarted() {
        this.processors.clear();
        SessionProcessorDescriptor[] sessionProcessorDescriptorArray = this.descriptors;
        int n = this.descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            SessionProcessorDescriptor d = sessionProcessorDescriptorArray[n2];
            if (d.isEnabled()) {
                this.processors.add(d.getProcessor());
            }
            ++n2;
        }
        super.sessionStarted();
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        List<ICompletionProposal> res = super.computeCompletionProposals(context, monitor);
        int offset = context.getInvocationOffset();
        if (!this.isContentAssistConfigurationOkay()) {
            EnableCompletionProposal config = new EnableCompletionProposal(this.images, offset);
            if (!res.isEmpty()) {
                return Collections.singletonList(config);
            }
            res.add((ICompletionProposal)new EmptyCompletionProposal(offset));
            res.add((ICompletionProposal)config);
            return res;
        }
        return res;
    }

    @VisibleForTesting
    protected boolean isContentAssistConfigurationOkay() {
        HashSet cats = Sets.newHashSet((Object[])PreferenceConstants.getExcludedCompletionProposalCategories());
        if (cats.contains("org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent")) {
            return true;
        }
        return !this.isJdtAllEnabled(cats) && !this.isMylynInstalledAndEnabled(cats);
    }

    private boolean isMylynInstalledAndEnabled(Set<String> cats) {
        return IntelligentCompletionProposalComputer.isMylynInstalled() && !cats.contains("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
    }

    private boolean isJdtAllEnabled(Set<String> cats) {
        return !cats.contains("org.eclipse.jdt.ui.javaAllProposalCategory");
    }

    public static boolean isMylynInstalled() {
        CompletionProposalComputerRegistry reg = CompletionProposalComputerRegistry.getDefault();
        for (CompletionProposalCategory cat : reg.getProposalCategories()) {
            if (!cat.getId().equals("org.eclipse.mylyn.java.ui.javaAllProposalCategory")) continue;
            return true;
        }
        return false;
    }
}

