/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaAllCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.internal.completion.rcp.Messages;
import org.eclipse.recommenders.internal.rcp.RcpPlugin;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.utils.Checks;

public abstract class ProcessableCompletionProposalComputer
extends JavaAllCompletionProposalComputer
implements ICompletionListener,
ICompletionListenerExtension2 {
    public static final CompletionProposal NULL_PROPOSAL = new CompletionProposal();
    public IProcessableProposalFactory proposalFactory;
    private IAstProvider astProvider;
    public Set<SessionProcessor> processors;
    private Set<SessionProcessor> active;
    public JavaContentAssistInvocationContext jdtContext;
    public IRecommendersCompletionContext crContext;
    public ContentAssistantFacade contentAssist;
    public Map<CompletionContextKey, ICompletionContextFunction> functions;

    public ProcessableCompletionProposalComputer(IProcessableProposalFactory proposalFactory, IAstProvider astProvider) {
        this(proposalFactory, Sets.newLinkedHashSet(), astProvider);
    }

    public ProcessableCompletionProposalComputer(IProcessableProposalFactory proposalFactory, Set<SessionProcessor> processors, IAstProvider astProvider) {
        this(proposalFactory, processors, astProvider, Maps.newHashMap());
    }

    public ProcessableCompletionProposalComputer(IProcessableProposalFactory proposalFactory, Set<SessionProcessor> processors, IAstProvider astProvider, Map<CompletionContextKey, ICompletionContextFunction> functions) {
        this.proposalFactory = proposalFactory;
        this.processors = processors;
        this.astProvider = astProvider;
        this.functions = functions;
    }

    public void sessionStarted() {
        this.active = Sets.newHashSet(this.processors);
        this.unregisterCompletionListener();
    }

    public void sessionEnded() {
        this.fireAboutToClose();
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        LinkedList res = Lists.newLinkedList();
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return res;
        }
        this.storeContext(context);
        this.registerCompletionListener();
        this.fireStartSession(this.crContext);
        for (Map.Entry<IJavaCompletionProposal, CompletionProposal> pair : this.crContext.getProposals().entrySet()) {
            IJavaCompletionProposal jdtProposal = ProcessableProposalFactory.create(pair.getValue(), pair.getKey(), this.jdtContext, this.proposalFactory);
            res.add(jdtProposal);
            if (!(jdtProposal instanceof IProcessableProposal)) continue;
            IProcessableProposal crProposal = (IProcessableProposal)jdtProposal;
            crProposal.setTag(ProposalTag.CONTEXT, this.crContext);
            this.fireProcessProposal(crProposal);
        }
        this.fireEndComputation(res);
        this.fireAboutToShow(res);
        return res;
    }

    private void storeContext(ContentAssistInvocationContext context) {
        this.jdtContext = (JavaContentAssistInvocationContext)Checks.cast((Object)context);
        this.crContext = new RecommendersCompletionContext(this.jdtContext, this.astProvider, this.functions);
    }

    private void registerCompletionListener() {
        ITextViewer v = this.jdtContext.getViewer();
        if (!(v instanceof SourceViewer)) {
            return;
        }
        SourceViewer sv = (SourceViewer)v;
        this.contentAssist = sv.getContentAssistantFacade();
        this.contentAssist.addCompletionListener((ICompletionListener)this);
    }

    protected void fireStartSession(IRecommendersCompletionContext crContext) {
        Iterator<SessionProcessor> it = this.active.iterator();
        while (it.hasNext()) {
            SessionProcessor p = it.next();
            try {
                boolean interested = p.startSession(crContext);
                if (interested) continue;
                it.remove();
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireProcessProposal(IProcessableProposal proposal) {
        for (SessionProcessor p : this.active) {
            try {
                proposal.getRelevance();
                p.process(proposal);
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
        proposal.getProposalProcessorManager().prefixChanged(this.crContext.getPrefix());
    }

    protected void fireEndComputation(List<ICompletionProposal> proposals) {
        for (SessionProcessor p : this.active) {
            try {
                p.endSession(proposals);
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireAboutToShow(List<ICompletionProposal> proposals) {
        for (SessionProcessor p : this.active) {
            try {
                p.aboutToShow(proposals);
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireAboutToClose() {
        for (SessionProcessor p : this.active) {
            try {
                p.aboutToClose();
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void assistSessionEnded(ContentAssistEvent event) {
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        for (SessionProcessor p : this.active) {
            try {
                p.selected(proposal);
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    public void applied(ICompletionProposal proposal) {
        for (SessionProcessor p : this.active) {
            try {
                p.applied(proposal);
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)Messages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Object[])new Object[]{p.getClass()});
            }
        }
        this.unregisterCompletionListener();
    }

    private void unregisterCompletionListener() {
        if (this.contentAssist != null) {
            this.contentAssist.removeCompletionListener((ICompletionListener)this);
        }
    }
}

