/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.graphics.Image;

public class ProcessableOverrideCompletionProposal
extends OverrideCompletionProposal
implements IProcessableProposal {
    private Map<IProposalTag, Object> tags = Maps.newHashMap();
    private ProposalProcessorManager mgr;
    private CompletionProposal coreProposal;
    private String lastPrefix;

    public ProcessableOverrideCompletionProposal(CompletionProposal coreProposal, JavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        super(context.getProject(), context.getCompilationUnit(), String.valueOf(coreProposal.getName()), ProcessableOverrideCompletionProposal.computeParamTypes(coreProposal), coreProposal.getReplaceStart(), uiProposal.getReplacementLength(), uiProposal.getStyledDisplayString(), String.valueOf(coreProposal.getCompletion()));
        this.coreProposal = coreProposal;
        Image image = uiProposal.getImage();
        this.setImage(image);
        this.setRelevance(uiProposal.getRelevance());
    }

    private static String[] computeParamTypes(CompletionProposal proposal) {
        String[] paramTypes = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
        int index = 0;
        while (index < paramTypes.length) {
            paramTypes[index] = Signature.toString((String)paramTypes[index]);
            ++index;
        }
        return paramTypes;
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        if (this.mgr.prefixChanged(prefix)) {
            return true;
        }
        return super.isPrefix(prefix, completion);
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public void setTag(IProposalTag key, Object value) {
        Checks.ensureIsNotNull((Object)key);
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> getTag(IProposalTag key) {
        return Optional.fromNullable((Object)this.tags.get(key));
    }

    @Override
    public <T> T getTag(IProposalTag key, T defaultValue) {
        Object res = this.tags.get(key);
        return (T)(res != null ? res : defaultValue);
    }
}

