/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionProcessorDescriptor
implements Comparable<SessionProcessorDescriptor> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionProcessorDescriptor.class);
    private static final String PREF_NODE_ID_SESSIONPROCESSORS = "org.eclipse.recommenders.completion.rcp.sessionprocessors";
    private static final String PREF_DISABLED = "disabled";
    private static final String EXT_POINT_SESSION_PROCESSORS = "org.eclipse.recommenders.completion.rcp.sessionprocessors";
    private String id;
    private String name;
    private String description;
    private Image icon;
    private int priority;
    private boolean enabled;
    private SessionProcessor processor;
    private String preferencePageId;

    public static SessionProcessorDescriptor[] parseExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.recommenders.completion.rcp.sessionprocessors");
        Set<String> disabledProcessors = SessionProcessorDescriptor.getDisabledProcessors();
        PriorityQueue<SessionProcessorDescriptor> queue = new PriorityQueue<SessionProcessorDescriptor>();
        try {
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                try {
                    String pluginId = elem.getContributor().getName();
                    String id = elem.getAttribute("id");
                    String name = elem.getAttribute("name");
                    String description = elem.getAttribute("description");
                    String iconPath = elem.getAttribute("icon");
                    String priorityString = elem.getAttribute("priority");
                    String preferencePageId = elem.getAttribute("preferencePage");
                    int priority = priorityString == null ? 10 : Integer.parseInt(priorityString);
                    Image icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconPath).createImage();
                    SessionProcessor processor = (SessionProcessor)elem.createExecutableExtension("class");
                    boolean enable = !disabledProcessors.contains(id);
                    SessionProcessorDescriptor d = new SessionProcessorDescriptor(id, name, description, icon, priority, enable, preferencePageId, processor);
                    queue.add(d);
                }
                catch (Exception e) {
                    LOG.error("Exception during extension point parsing.", (Throwable)e);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error("Exception during extension point parsing", (Throwable)e);
        }
        SessionProcessorDescriptor[] res = queue.toArray(new SessionProcessorDescriptor[0]);
        return res;
    }

    private static Set<String> getDisabledProcessors() {
        String prefs = SessionProcessorDescriptor.getSessionProcessorPreferences().get(PREF_DISABLED, "");
        Iterable split = Splitter.on((char)';').omitEmptyStrings().split((CharSequence)prefs);
        return Sets.newHashSet((Iterable)split);
    }

    private static void saveDisabledProcessors(Set<String> disabledProcessors) {
        String join = Joiner.on((char)';').skipNulls().join(disabledProcessors);
        IEclipsePreferences store = SessionProcessorDescriptor.getSessionProcessorPreferences();
        store.put(PREF_DISABLED, join);
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Failed to flush preferences", (Throwable)e);
        }
    }

    private static IEclipsePreferences getSessionProcessorPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.completion.rcp.sessionprocessors");
    }

    public SessionProcessorDescriptor(String id, String name, String description, Image icon, int priority, boolean enabled, String preferencePageId, SessionProcessor processor) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.priority = priority;
        this.enabled = enabled;
        this.preferencePageId = preferencePageId;
        this.processor = processor;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return StringUtils.defaultString((String)this.description, (String)"");
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getPriority() {
        return this.priority;
    }

    public SessionProcessor getProcessor() {
        return this.processor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        Set<String> disabledProcessors = SessionProcessorDescriptor.getDisabledProcessors();
        if (enable) {
            disabledProcessors.remove(this.id);
        } else {
            disabledProcessors.add(this.id);
        }
        SessionProcessorDescriptor.saveDisabledProcessors(disabledProcessors);
    }

    public Optional<String> getPreferencePage() {
        return Optional.fromNullable((Object)this.preferencePageId);
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int compareTo(SessionProcessorDescriptor o) {
        String other = String.valueOf(o.priority) + o.id;
        String self = String.valueOf(this.priority) + this.id;
        return self.compareTo(other);
    }

    public static final class EnabledSessionProcessorPredicate
    implements Predicate<SessionProcessorDescriptor> {
        public boolean apply(SessionProcessorDescriptor p) {
            return p.isEnabled();
        }
    }
}

