/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.internal.completion.rcp.Messages;
import org.eclipse.recommenders.rcp.utils.ContentAssistEnablementBlock;
import org.eclipse.recommenders.rcp.utils.ObjectToBooleanConverter;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CompletionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Set<SessionProcessorDescriptor> processors;
    Set<SessionProcessorDescriptor> enabled;
    private CheckboxTableViewer viewer;
    private DataBindingContext ctx;
    private IViewerObservableSet checked;
    private Button configureBtn;
    private IViewerObservableValue selected;

    @Inject
    public CompletionsPreferencePage(SessionProcessorDescriptor[] pr) {
        this.processors = ImmutableSet.copyOf((Object[])pr);
        this.enabled = Sets.filter(this.processors, (Predicate)new SessionProcessorDescriptor.EnabledSessionProcessorPredicate());
    }

    public void init(IWorkbench workbench) {
        this.setMessage(Messages.PREFPAGE_TITLE_COMPLETIONS);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_COMPLETIONS);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)new GridLayout(2, false));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().hint(300, 150).grab(true, false).create());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.configureBtn = new Button(container, 8);
        this.configureBtn.setText(Messages.BUTTON_LABEL_CONFIGURE);
        this.configureBtn.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).create());
        this.configureBtn.setEnabled(false);
        this.configureBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionProcessorDescriptor value = (SessionProcessorDescriptor)Checks.cast((Object)CompletionsPreferencePage.this.selected.getValue());
                String id = (String)value.getPreferencePage().orNull();
                PreferencesUtil.createPreferenceDialogOn((Shell)CompletionsPreferencePage.this.getShell(), (String)id, null, null);
            }
        });
        ContentAssistEnablementBlock enable = new ContentAssistEnablementBlock(container, Messages.FIELD_LABEL_ENABLE_COMPLETION, "org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent"){

            protected void additionalExcludedCompletionCategoriesUpdates(boolean isEnabled, Set<String> cats) {
                if (isEnabled) {
                    cats.add("org.eclipse.jdt.ui.javaAllProposalCategory");
                    cats.add("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                } else if (2.isMylynInstalled()) {
                    cats.remove("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                } else {
                    cats.remove("org.eclipse.jdt.ui.javaAllProposalCategory");
                }
            }

            public void loadSelection() {
                Object[] excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
                boolean deactivated = ArrayUtils.contains((Object[])excluded, (Object)"org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent");
                boolean mylynActive = 2.isMylynInstalled() && !ArrayUtils.contains((Object[])excluded, (Object)"org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                boolean jdtActive = !ArrayUtils.contains((Object[])excluded, (Object)"org.eclipse.jdt.ui.javaAllProposalCategory");
                this.enablement.setSelection(!deactivated && !mylynActive && !jdtActive);
                this.enablement.setToolTipText(Messages.FIELD_TOOLTIP_ENABLE_COMPLETION);
            }
        };
        enable.loadSelection();
        Link contentAssistLink = new Link(container, 64);
        contentAssistLink.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).create());
        contentAssistLink.setText(Messages.PREFPAGE_FOOTER_COMPLETIONS);
        contentAssistLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)CompletionsPreferencePage.this.getShell(), (String)"org.eclipse.jdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null);
            }
        });
        this.initDataBindings();
        return container;
    }

    protected void initDataBindings() {
        this.ctx = new DataBindingContext();
        ObservableSetContentProvider cp = new ObservableSetContentProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object o) {
                return this.s(o).getName();
            }

            public Image getImage(Object o) {
                return this.s(o).getIcon();
            }

            public String getToolTipText(Object o) {
                return this.s(o).getDescription();
            }

            private SessionProcessorDescriptor s(Object element) {
                return (SessionProcessorDescriptor)Checks.cast((Object)element);
            }
        });
        this.viewer.setContentProvider((IContentProvider)cp);
        IObservableSet processors = Properties.selfSet(this.processors).observe(this.processors);
        this.viewer.setInput((Object)processors);
        this.checked = ViewerProperties.checkedElements(SessionProcessorDescriptor.class).observe((Viewer)this.viewer);
        this.viewer.setCheckedElements(this.enabled.toArray());
        this.selected = ViewersObservables.observeSinglePostSelection((StructuredViewer)this.viewer);
        ISWTObservableValue configure = WidgetProperties.enabled().observe((Widget)this.configureBtn);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new ObjectToBooleanConverter(){

            public Boolean convert(Object fromObject) {
                Boolean convert = super.convert(fromObject);
                SessionProcessorDescriptor value = (SessionProcessorDescriptor)Checks.cast((Object)CompletionsPreferencePage.this.selected.getValue());
                if (convert.booleanValue() && value.getPreferencePage().isPresent()) {
                    return true;
                }
                return false;
            }
        });
        this.ctx.bindValue((IObservableValue)this.selected, (IObservableValue)configure, strategy, null);
    }

    public boolean performOk() {
        for (SessionProcessorDescriptor d : this.checked) {
            d.setEnabled(true);
        }
        for (SessionProcessorDescriptor d : Sets.difference(this.processors, (Set)this.checked)) {
            d.setEnabled(false);
        }
        return super.performOk();
    }

    public void dispose() {
        this.ctx.dispose();
    }
}

